/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.geo;

import drasys.or.geom.CoordinateSystemI;
import drasys.or.geom.RangeI;
import drasys.or.geom.geo.Ellipsoid;
import drasys.or.geom.geo.EllipsoidI;
import drasys.or.geom.geo.Point;
import drasys.or.geom.geo.PointI;
import drasys.or.geom.geo.Range;
import drasys.or.matrix.VectorI;
import java.io.Serializable;

public class CoordinateSystem
implements CoordinateSystemI,
Serializable {
    private static String[] _dimensionNames = new String[]{"longitude", "latitude"};
    private static CoordinateSystem _coordSys = new CoordinateSystem();
    private static EllipsoidI _ellipsoid = Ellipsoid.getInstance("WGS 84");
    protected static double _accuracy = 1.0E-6;

    private CoordinateSystem() {
    }

    public String dimensionName(int n) {
        return _dimensionNames[n];
    }

    public boolean equals(double d, double d2) {
        return Math.abs(d - d2) <= _accuracy;
    }

    public boolean equals(Object object) {
        return object instanceof CoordinateSystem;
    }

    public double getAccuracy() {
        return _accuracy;
    }

    public static EllipsoidI getEllipsoid() {
        return _ellipsoid;
    }

    public static CoordinateSystem getInstance() {
        return _coordSys;
    }

    public drasys.or.geom.PointI getPointInstance(drasys.or.geom.PointI pointI) {
        return new Point((PointI)pointI);
    }

    public drasys.or.geom.PointI getPointInstance(VectorI vectorI) {
        return new Point(vectorI);
    }

    public drasys.or.geom.PointI getPointInstance(double[] dArray) {
        return new Point(dArray);
    }

    public RangeI getRangeInstance(drasys.or.geom.PointI pointI, drasys.or.geom.PointI pointI2) {
        return new Range((PointI)pointI, (PointI)pointI2);
    }

    public RangeI getRangeInstance(RangeI rangeI) {
        return new Range((drasys.or.geom.geo.RangeI)rangeI);
    }

    public boolean isSymmetric() {
        return true;
    }

    public static void setAccuracy(double d) {
        _accuracy = d;
    }

    public static void setEllipsoid(EllipsoidI ellipsoidI) {
        _ellipsoid = ellipsoidI;
    }

    public int sizeOfDimensions() {
        return 2;
    }

    public String toString() {
        return "geo";
    }
}

