/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.vrp;

import drasys.or.CompareI;
import drasys.or.alg.QuickSort;
import drasys.or.geom.PointI;
import drasys.or.graph.ElementI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.ImproveI;
import drasys.or.graph.tsp.TourNotFoundException;
import drasys.or.graph.vrp.ConstructI;
import drasys.or.graph.vrp.RandomizableBase;
import drasys.or.graph.vrp.RandomizableI;
import drasys.or.graph.vrp.SolutionNotFoundException;
import java.util.Enumeration;
import java.util.Vector;

public class GillettMillerBase
extends RandomizableBase
implements ConstructI,
RandomizableI {
    int _pos;
    int _numTours = 0;
    Node _depot;
    Node _insertion;
    Tour _tourList;
    Vector _nodes;

    public GillettMillerBase() {
    }

    public GillettMillerBase(ImproveI improveI) {
        super(improveI);
    }

    private void buildTours() throws SolutionNotFoundException {
        this._pos = 0;
        this._numTours = 0;
        this._tourList = null;
        Node node = this.nextNode();
        if (node == null) {
            throw new SolutionNotFoundException("There are no nodes.");
        }
        Tour tour = this._tourList = new Tour(this._depot, node);
        ++this._numTours;
        while ((node = this.nextNode()) != null) {
            boolean bl = true;
            boolean bl2 = false;
            while (bl) {
                bl = false;
                double d = tour._cost + this.findInsertion(tour, node);
                double d2 = tour._load + this.getLoad(node);
                if (d > this._maxCost && this._improve != null && !bl2) {
                    bl = true;
                    bl2 = true;
                    this.improve(tour);
                    continue;
                }
                if (d2 > this._maxLoad || d > this._maxCost) {
                    tour = new Tour(this._depot, node);
                    tour._nextTour = this._tourList;
                    this._tourList = tour;
                    ++this._numTours;
                    continue;
                }
                this.insert(tour, node);
                tour._cost = d;
                tour._load = d2;
                ++tour._sizeOfNodes;
            }
        }
    }

    private void construct() throws SolutionNotFoundException, VertexNotFoundException {
        if (this._graph == null) {
            throw new SolutionNotFoundException("The graph is not set");
        }
        VertexI vertexI = this._graph.getVertex(this._depotKey);
        if (vertexI == null) {
            throw new VertexNotFoundException("Can't find the Depot: " + this._depotKey);
        }
        this._depot = new Node(vertexI, 0.0);
        this.initNodes();
        this.buildTours();
        this._nodes = null;
    }

    public double constructClosedTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        this._closed = true;
        this._depotKey = object;
        this.construct();
        return this.getCost();
    }

    public double constructInboundTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        this._closed = false;
        this._out = false;
        this._depotKey = object;
        this.construct();
        return this.getCost();
    }

    public double constructOutboundTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        this._closed = false;
        this._out = true;
        this._depotKey = object;
        this.construct();
        return this.getCost();
    }

    private double findInsertion(Tour tour, Node node) {
        double d = this.getCost(node, tour._first);
        if (this._closed || this._out) {
            d += this.getCost(this._depot, node) - this.getCost(this._depot, tour._first);
        }
        this._insertion = this._depot;
        double d2 = d;
        d = this.getCost(tour._last, node);
        if (this._closed || !this._out) {
            d += this.getCost(node, this._depot) - this.getCost(tour._last, this._depot);
        }
        if (d < d2) {
            this._insertion = tour._last;
            d2 = d;
        }
        Node node2 = tour._first;
        while (node2 != tour._last) {
            d = this.getCost(node2, node) + this.getCost(node, node2._next) - this.getCost(node2, node2._next);
            if (d < d2) {
                this._insertion = node2;
                d2 = d;
            }
            node2 = node2._next;
        }
        return d2;
    }

    public double getCost() throws SolutionNotFoundException {
        if (this._numTours == 0) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        double d = 0.0;
        Tour tour = this._tourList;
        while (tour != null) {
            d += tour._cost;
            tour = tour._nextTour;
        }
        return d;
    }

    private double getCost(Node node, Node node2) {
        return this.getCost(node._vertex, node2._vertex);
    }

    public double[] getCosts() throws SolutionNotFoundException {
        if (this._numTours == 0) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        double[] dArray = new double[this._numTours];
        int n = 0;
        Tour tour = this._tourList;
        while (tour != null) {
            dArray[n++] = tour._cost;
            tour = tour._nextTour;
        }
        return dArray;
    }

    private double getLoad(Node node) {
        return this.getLoad(node._vertex);
    }

    public double[] getLoads() throws SolutionNotFoundException {
        if (this._numTours == 0) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        double[] dArray = new double[this._numTours];
        int n = 0;
        Tour tour = this._tourList;
        while (tour != null) {
            dArray[n++] = tour._load;
            tour = tour._nextTour;
        }
        return dArray;
    }

    public Vector[] getTours() throws SolutionNotFoundException {
        if (this._numTours == 0) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        int n = 0;
        Vector[] vectorArray = new Vector[this._numTours];
        Tour tour = this._tourList;
        while (tour != null) {
            int n2 = n++;
            Vector<ElementI> vector = new Vector<ElementI>();
            vectorArray[n2] = vector;
            Vector<ElementI> vector2 = vector;
            if (this._closed || this._out) {
                vector2.addElement(this._depot._vertex);
                vector2.addElement(this._graph.getEdge(this._depot._vertex, tour._first._vertex, this._edgeKey));
            }
            Node node = tour._first;
            vector2.addElement(node._vertex);
            Node node2 = node._next;
            while (node2 != null) {
                vector2.addElement(this._graph.getEdge(node._vertex, node2._vertex, this._edgeKey));
                vector2.addElement(node2._vertex);
                node = node2;
                node2 = node2._next;
            }
            if (this._closed || !this._out) {
                vector2.addElement(this._graph.getEdge(tour._last._vertex, this._depot._vertex, this._edgeKey));
                vector2.addElement(this._depot._vertex);
            }
            tour = tour._nextTour;
        }
        return vectorArray;
    }

    private void improve(Tour tour) throws SolutionNotFoundException {
        double d;
        double d2 = tour._cost;
        Vector<VertexI> vector = new Vector<VertexI>(tour._sizeOfNodes + 2);
        if (this._closed || this._out) {
            vector.addElement(this._depot._vertex);
            vector.addElement(null);
        }
        Node node = tour._first;
        vector.addElement(node._vertex);
        while ((node = node._next) != null) {
            vector.addElement(null);
            vector.addElement(node._vertex);
        }
        if (this._closed || !this._out) {
            vector.addElement(null);
            vector.addElement(this._depot._vertex);
        }
        try {
            d = this._closed ? this._improve.improveClosedTour(vector) : (this._out ? this._improve.improveOpenTour(vector, true, false) : this._improve.improveOpenTour(vector, false, true));
        }
        catch (TourNotFoundException tourNotFoundException) {
            throw new SolutionNotFoundException("Subalg: " + tourNotFoundException.getMessage());
        }
        tour._cost = this._vehicleCost + d;
        double d3 = d2 - tour._cost;
        if (d3 < -1.0E-6) {
            throw new SolutionNotFoundException("The subalgorithm increased the tour cost by: " + -d3);
        }
        Enumeration enumeration = this._improve.getTour().elements();
        if (this._closed || this._out) {
            enumeration.nextElement();
            enumeration.nextElement();
        }
        node = tour._first;
        node = tour._first;
        while (node != tour._last) {
            node._vertex = (VertexI)enumeration.nextElement();
            enumeration.nextElement();
            node = node._next;
        }
        tour._last._vertex = (VertexI)enumeration.nextElement();
    }

    private void initNodes() throws SolutionNotFoundException {
        Object object;
        double d;
        this._nodes = new Vector();
        if (!(this._depot._vertex.getValue() instanceof PointI)) {
            throw new SolutionNotFoundException("Found a vertex value that does not implement 'geom.PointI'");
        }
        PointI pointI = (PointI)this._depot._vertex.getValue();
        Enumeration enumeration = this._graph.vertices();
        while (enumeration.hasMoreElements()) {
            VertexI vertexI = (VertexI)enumeration.nextElement();
            if (vertexI == this._depot._vertex || !this.isSelected(vertexI)) continue;
            if (!(vertexI.getValue() instanceof PointI)) {
                throw new SolutionNotFoundException("Found a vertex value that does not implement 'geom.PointI'");
            }
            PointI pointI2 = (PointI)vertexI.getValue();
            d = pointI.getDirectionTo(pointI2);
            object = new Node(vertexI, d);
            this._nodes.addElement(object);
        }
        if (this._strength > 0) {
            double d2 = Math.PI * 2;
            d = this._random.nextDouble() * d2 - Math.PI;
            object = this._nodes.elements();
            while (object.hasMoreElements()) {
                Node node = (Node)object.nextElement();
                if (!(node._dir < d)) continue;
                node._dir += d2;
            }
        }
        if (this._strength > 0 && this._random.nextDouble() > 0.5) {
            new QuickSort(true, new CmpDir()).sort(this._nodes);
        } else {
            new QuickSort(false, new CmpDir()).sort(this._nodes);
        }
    }

    private void insert(Tour tour, Node node) {
        if (this._insertion == this._depot) {
            node._next = tour._first;
            tour._first = node;
        } else if (this._insertion == tour._last) {
            tour._last._next = node;
            tour._last = node;
        } else {
            node._next = this._insertion._next;
            this._insertion._next = node;
        }
    }

    private Node nextNode() {
        int n = this._strength < 2 ? 0 : (int)(this._random.nextDouble() * (double)this._strength - 0.5);
        this._pos = this.nextPos(this._pos);
        if (this._pos >= this._nodes.size()) {
            return null;
        }
        int n2 = this._pos;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.nextPos(n2 + 1);
            if (n4 >= this._nodes.size()) break;
            n2 = n4;
            ++n3;
        }
        Node node = (Node)this._nodes.elementAt(n2);
        node._used = true;
        return node;
    }

    private int nextPos(int n) {
        while (n < this._nodes.size() && ((Node)this._nodes.elementAt((int)n))._used) {
            ++n;
        }
        return n;
    }

    class CmpDir
    implements CompareI {
        CmpDir() {
        }

        public int compare(Object object, Object object2) {
            if (((Node)object)._dir < ((Node)object2)._dir) {
                return -1;
            }
            if (((Node)object)._dir > ((Node)object2)._dir) {
                return 1;
            }
            return 0;
        }
    }

    class Node {
        Node _next = null;
        double _load = 0.0;
        boolean _used = false;
        VertexI _vertex = null;
        double _dir;

        Node(VertexI vertexI, double d) {
            this._dir = d;
            this._vertex = vertexI;
            this._load = GillettMillerBase.this.getLoad(vertexI);
        }
    }

    class Tour {
        Node _depot = null;
        Node _last = null;
        Node _first = null;
        Tour _nextTour = null;
        int _sizeOfNodes = 0;
        double _load = 0.0;
        double _cost = 0.0;

        Tour(Node node, Node node2) throws SolutionNotFoundException {
            this._depot = node;
            this._load = node2._load;
            this._last = node2;
            this._first = node2;
            this._cost = GillettMillerBase.this._vehicleCost;
            this._sizeOfNodes = 1;
            if (GillettMillerBase.this._closed || GillettMillerBase.this._out) {
                this._cost += GillettMillerBase.this.getCost(node, node2);
            }
            if (GillettMillerBase.this._closed || !GillettMillerBase.this._out) {
                this._cost += GillettMillerBase.this.getCost(node2, node);
            }
            if (this._cost > GillettMillerBase.this._maxCost) {
                throw new SolutionNotFoundException("A node singularly exceeds the cost constraint:" + this._cost + ">" + GillettMillerBase.this._maxCost);
            }
            if (this._load > GillettMillerBase.this._maxLoad) {
                throw new SolutionNotFoundException("A node singularly exceeds the load constraint:" + this._load + ">" + GillettMillerBase.this._maxLoad);
            }
        }
    }
}

