/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.Matrix;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.SizableMatrixI;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SparseMatrix
extends Matrix
implements SizableMatrixI {
    Element _tmpElement = new Element(0, 0, 0.0);
    Hashtable _index;
    Vector _rows;
    Vector _columns;

    public SparseMatrix(int n, int n2) {
        this._rows = new Vector(n);
        this._rows.setSize(n);
        this._columns = new Vector(n2);
        this._columns.setSize(n2);
        this._index = new Hashtable(Math.max(10, n + n2));
    }

    public SparseMatrix(MatrixI matrixI) {
        this._rows = new Vector(matrixI.sizeOfRows());
        this._rows.setSize(matrixI.sizeOfRows());
        this._columns = new Vector(matrixI.sizeOfColumns());
        this._columns.setSize(matrixI.sizeOfColumns());
        this._index = new Hashtable(Math.max(10, matrixI.sizeOfElements()));
        Enumeration enumeration = matrixI.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            this.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), matrixElementI.getValue());
        }
    }

    public SparseMatrix(MatrixI matrixI, double d) {
        super(d);
        this._rows = new Vector(matrixI.sizeOfRows());
        this._rows.setSize(matrixI.sizeOfRows());
        this._columns = new Vector(matrixI.sizeOfColumns());
        this._columns.setSize(matrixI.sizeOfColumns());
        this._index = new Hashtable(Math.max(10, matrixI.sizeOfElements()));
        Enumeration enumeration = matrixI.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            double d2 = matrixElementI.getValue();
            if (this.equals(d2, 0.0)) continue;
            this.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), d2);
        }
    }

    public SparseMatrix(VectorI vectorI) {
        this._rows = new Vector(vectorI.size());
        this._rows.setSize(vectorI.size());
        this._columns = new Vector(vectorI.size());
        this._columns.setSize(vectorI.size());
        this._index = new Hashtable(Math.max(10, vectorI.sizeOfElements()));
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(vectorElementI.getIndex(), vectorElementI.getIndex(), vectorElementI.getValue());
        }
    }

    public SparseMatrix(VectorI vectorI, double d) {
        super(d);
        this._rows = new Vector(vectorI.size());
        this._rows.setSize(vectorI.size());
        this._columns = new Vector(vectorI.size());
        this._columns.setSize(vectorI.size());
        this._index = new Hashtable(Math.max(10, vectorI.sizeOfElements()));
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            double d2 = vectorElementI.getValue();
            if (this.equals(d2, 0.0)) continue;
            this.setElementAt(vectorElementI.getIndex(), vectorElementI.getIndex(), d2);
        }
    }

    public SparseMatrix(double[][] dArray) {
        double[] dArray2;
        int n;
        int n2 = 0;
        int n3 = 0;
        if (dArray != null) {
            n3 = dArray.length;
            n = 0;
            while (n < dArray.length) {
                dArray2 = dArray[n];
                if (dArray2 != null && dArray2.length > n2) {
                    n2 = dArray2.length;
                }
                ++n;
            }
        }
        this._rows = new Vector(n3);
        this._rows.setSize(n3);
        this._columns = new Vector(n2);
        this._columns.setSize(n2);
        this._index = new Hashtable(Math.max(10, n3 * n2));
        if (dArray == null) {
            return;
        }
        n = 0;
        while (n < dArray.length) {
            dArray2 = dArray[n];
            if (dArray2 != null) {
                int n4 = 0;
                while (n4 < dArray2.length) {
                    Element element = new Element(n, n4, dArray2[n4]);
                    this._index.put(element, element);
                    element._nextRow = (Element)this._rows.elementAt(element._row);
                    this._rows.setElementAt(element, element._row);
                    element._nextColumn = (Element)this._columns.elementAt(element._column);
                    this._columns.setElementAt(element, element._column);
                    ++n4;
                }
            }
            ++n;
        }
    }

    public SparseMatrix(double[][] dArray, double d) {
        super(d);
        double[] dArray2;
        int n;
        int n2 = 0;
        int n3 = 0;
        if (dArray != null) {
            n3 = dArray.length;
            n = 0;
            while (n < dArray.length) {
                dArray2 = dArray[n];
                if (dArray2 != null && dArray2.length > n2) {
                    n2 = dArray2.length;
                }
                ++n;
            }
        }
        this._rows = new Vector(n3);
        this._rows.setSize(n3);
        this._columns = new Vector(n2);
        this._columns.setSize(n2);
        this._index = new Hashtable(Math.max(10, n3 * n2));
        if (dArray == null) {
            return;
        }
        n = 0;
        while (n < dArray.length) {
            dArray2 = dArray[n];
            if (dArray2 != null) {
                int n4 = 0;
                while (n4 < dArray2.length) {
                    double d2 = dArray2[n4];
                    if (!this.equals(d2, 0.0)) {
                        Element element = new Element(n, n4, d2);
                        this._index.put(element, element);
                        element._nextRow = (Element)this._rows.elementAt(element._row);
                        this._rows.setElementAt(element, element._row);
                        element._nextColumn = (Element)this._columns.elementAt(element._column);
                        this._columns.setElementAt(element, element._column);
                    }
                    ++n4;
                }
            }
            ++n;
        }
    }

    public void addColumn(VectorI vectorI) {
        int n = this.sizeOfColumns();
        this.setSize(this.sizeOfRows(), this.sizeOfColumns() + 1);
        if (vectorI == null) {
            return;
        }
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n2 = vectorElementI.getIndex();
            if (n2 <= this.sizeOfRows()) continue;
            this.setElementAt(n2, n, vectorElementI.getValue());
        }
    }

    public void addRow(VectorI vectorI) {
        int n = this.sizeOfRows();
        this.setSize(this.sizeOfRows() + 1, this.sizeOfColumns());
        if (vectorI == null) {
            return;
        }
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n2 = vectorElementI.getIndex();
            if (n2 <= this.sizeOfColumns()) continue;
            this.setElementAt(n, n2, vectorElementI.getValue());
        }
    }

    public int capacityOfColumns() {
        return this._columns.capacity();
    }

    public int capacityOfRows() {
        return this._rows.capacity();
    }

    public Enumeration columnElements(int n) {
        if (n < 0 || n >= this._columns.size()) {
            throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._columns.size());
        }
        return new ColumnEnum((Element)this._columns.elementAt(n));
    }

    public double elementAt(int n, int n2) {
        if (n < 0 || n >= this._rows.size()) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._rows.size());
        }
        if (n2 < 0 || n2 >= this._columns.size()) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._columns.size());
        }
        this._tmpElement._row = n;
        this._tmpElement._column = n2;
        Element element = (Element)this._index.get(this._tmpElement);
        return element == null ? 0.0 : element._value;
    }

    public Enumeration elements() {
        return this._index.elements();
    }

    public double[][] getArray() {
        double[][] dArray = new double[this.sizeOfRows()][this.sizeOfColumns()];
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            dArray[matrixElementI.getRowIndex()][matrixElementI.getColumnIndex()] = matrixElementI.getValue();
        }
        return dArray;
    }

    public boolean isColumnMajor() {
        return false;
    }

    public boolean isNull(int n, int n2) {
        if (n < 0 || n >= this._rows.size()) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._rows.size());
        }
        if (n2 < 0 || n2 >= this._columns.size()) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._columns.size());
        }
        this._tmpElement._row = n;
        this._tmpElement._column = n2;
        Element element = (Element)this._index.get(this._tmpElement);
        return element == null;
    }

    public boolean isRowMajor() {
        return false;
    }

    public Enumeration rowElements(int n) {
        if (n < 0 || n >= this._rows.size()) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._rows.size());
        }
        return new RowEnum((Element)this._rows.elementAt(n));
    }

    public void setCapacity(int n, int n2) {
        this._rows.ensureCapacity(n);
        this._columns.ensureCapacity(n2);
    }

    public void setElementAt(int n, int n2, double d) {
        if (n < 0 || n >= this._rows.size()) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._rows.size());
        }
        if (n2 < 0 || n2 >= this._columns.size()) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._columns.size());
        }
        this._tmpElement._row = n;
        this._tmpElement._column = n2;
        Element element = (Element)this._index.get(this._tmpElement);
        if (element == null) {
            element = new Element(n, n2, d);
            this._index.put(element, element);
            element._nextRow = (Element)this._rows.elementAt(element._row);
            this._rows.setElementAt(element, element._row);
            element._nextColumn = (Element)this._columns.elementAt(element._column);
            this._columns.setElementAt(element, element._column);
        } else {
            element._value = d;
        }
    }

    public void setElements(double d) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((MatrixElementI)enumeration.nextElement()).setValue(d);
        }
    }

    public void setSize(int n, int n2) {
        this._rows.setSize(n);
        this._columns.setSize(n2);
    }

    public int sizeOfColumns() {
        return this._columns.size();
    }

    public int sizeOfElements() {
        return this._index.size();
    }

    public int sizeOfRows() {
        return this._rows.size();
    }

    public double sum(int n, int n2, int n3, int n4) {
        double d = 0.0;
        while (n < n2) {
            Element element = (Element)this._rows.elementAt(n);
            while (element != null) {
                if (element.getColumnIndex() >= n3 && element.getColumnIndex() < n4) {
                    d += element.getValue();
                }
                element = element._nextRow;
            }
            ++n;
        }
        return d;
    }

    public double sumOfSquaredDifferences(int n, int n2, int n3, int n4, double d) {
        int n5 = 0;
        double d2 = 0.0;
        int n6 = (n2 - n) * (n4 - n3);
        while (n < n2) {
            Element element = (Element)this._rows.elementAt(n);
            while (element != null) {
                if (element.getColumnIndex() >= n3 && element.getColumnIndex() < n4) {
                    double d3 = element.getValue() - d;
                    d2 += d3 * d3;
                    ++n5;
                }
                element = element._nextRow;
            }
            ++n;
        }
        if (d != 0.0) {
            d2 += (double)(n6 - n5) * d * d;
        }
        return d2;
    }

    public double sumOfSquares(int n, int n2, int n3, int n4) {
        double d = 0.0;
        while (n < n2) {
            Element element = (Element)this._rows.elementAt(n);
            while (element != null) {
                if (element.getColumnIndex() >= n3 && element.getColumnIndex() < n4) {
                    double d2 = element.getValue();
                    d += d2 * d2;
                }
                element = element._nextRow;
            }
            ++n;
        }
        return d;
    }

    private static class Element
    implements MatrixElementI,
    Serializable {
        int _row;
        int _column;
        Element _nextRow;
        Element _nextColumn;
        double _value;

        Element(int n, int n2, double d) {
            this._row = n;
            this._column = n2;
            this._value = d;
        }

        public boolean equals(Object object) {
            Element element = (Element)object;
            return this._row == element._row && this._column == element._column;
        }

        public int getColumnIndex() {
            return this._column;
        }

        public int getRowIndex() {
            return this._row;
        }

        public double getValue() {
            return this._value;
        }

        public int hashCode() {
            return this._row * this._column;
        }

        public void setValue(double d) {
            this._value = d;
        }
    }

    private static class RowEnum
    implements Enumeration {
        Element _element;

        RowEnum(Element element) {
            this._element = element;
        }

        public boolean hasMoreElements() {
            return this._element != null;
        }

        public Object nextElement() {
            Element element = this._element;
            if (this._element != null) {
                this._element = this._element._nextRow;
            }
            return element;
        }
    }

    private static class ColumnEnum
    implements Enumeration {
        Element _element;

        ColumnEnum(Element element) {
            this._element = element;
        }

        public boolean hasMoreElements() {
            return this._element != null;
        }

        public Object nextElement() {
            Element element = this._element;
            if (this._element != null) {
                this._element = this._element._nextColumn;
            }
            return element;
        }
    }
}

