/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.mp.util;

import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.mp.ConstraintI;
import drasys.or.mp.MpError;
import drasys.or.mp.ProblemI;
import drasys.or.mp.VariableI;
import drasys.or.mp.util.ProblemWriterI;
import drasys.or.util.KeyGenerator;
import drasys.or.util.Metadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;

public class MPSWriter
extends PrintWriter
implements ProblemWriterI {
    String _header = null;
    String _rangeName = "RNG";
    String _boundName = "BND";
    String _objectiveName = "OBJ";
    String _rightHandSideName = "RHS";
    String _field1;
    String _field2;
    String _field3;
    String _field4;
    String _field5;
    String _field6;
    boolean _useBooleanBound = true;
    boolean _writeMetadata = true;
    String _blanks = "                                                    ";

    public MPSWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public MPSWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public MPSWriter(Writer writer) {
        super(writer);
    }

    public MPSWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    private void clear() {
        this._field6 = null;
        this._field5 = null;
        this._field4 = null;
        this._field3 = null;
        this._field2 = null;
        this._field1 = null;
    }

    private void printFields() {
        int n;
        int n2;
        String string = " ";
        if (this._header != null) {
            this.println(this._header);
            this._header = null;
        }
        if (this._field1 != null) {
            string = String.valueOf(string) + this._field1;
        }
        if ((n2 = (n = 5) - (string = String.valueOf(string) + " ").length() - 1) > 0) {
            string = String.valueOf(string) + this._blanks.substring(0, n2);
        }
        if (this._field2 != null) {
            string = String.valueOf(string) + this._field2;
        }
        if ((n2 = (n = 15) - (string = String.valueOf(string) + " ").length() - 1) > 0) {
            string = String.valueOf(string) + this._blanks.substring(0, n2);
        }
        if (this._field3 != null) {
            string = String.valueOf(string) + this._field3;
        }
        if ((n2 = (n = 25) - (string = String.valueOf(string) + " ").length() - 1) > 0) {
            string = String.valueOf(string) + this._blanks.substring(0, n2);
        }
        if (this._field4 != null) {
            string = String.valueOf(string) + this._field4;
        }
        if ((n2 = (n = 40) - (string = String.valueOf(string) + " ").length() - 1) > 0) {
            string = String.valueOf(string) + this._blanks.substring(0, n2);
        }
        if (this._field5 != null) {
            string = String.valueOf(string) + this._field5;
        }
        if ((n2 = (n = 50) - (string = String.valueOf(string) + " ").length() - 1) > 0) {
            string = String.valueOf(string) + this._blanks.substring(0, n2);
        }
        if (this._field6 != null) {
            string = String.valueOf(string) + this._field6;
        }
        this.println(string);
    }

    public void setBoundName(String string) {
        this._boundName = string;
    }

    public void setObjectiveName(String string) {
        this._objectiveName = string;
    }

    public void setRangeName(String string) {
        this._rangeName = string;
    }

    public void setRightHandSideName(String string) {
        this._rightHandSideName = string;
    }

    public void setUseBooleanBound(boolean bl) {
        this._useBooleanBound = bl;
    }

    public void setWriteMetadata(boolean bl) {
        this._writeMetadata = bl;
    }

    public void writeProblem(ProblemI problemI) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        KeyGenerator keyGenerator = new KeyGenerator(8);
        MatrixI matrixI = problemI.getCoefficientMatrix();
        String[] stringArray = new String[problemI.sizeOfVariables()];
        Enumeration enumeration = problemI.variables();
        while (enumeration.hasMoreElements()) {
            stringArray[(object10 = (VariableI)enumeration.nextElement()).getColumnIndex()] = object10.getName();
            if (stringArray[(object10 = (VariableI)enumeration.nextElement()).getColumnIndex()] != null) continue;
            String string = keyGenerator.nextKey();
            stringArray[object10.getColumnIndex()] = string;
            object9 = string;
            while (problemI.getVariable((String)object9) != null) {
                String string2 = keyGenerator.nextKey();
                stringArray[object10.getColumnIndex()] = string2;
                object9 = string2;
            }
        }
        object10 = new String[problemI.sizeOfConstraints()];
        object9 = problemI.constraints();
        while (object9.hasMoreElements()) {
            object10[(object8 = (ConstraintI)object9.nextElement()).getRowIndex()] = object8.getName();
            if (object10[(object8 = (ConstraintI)object9.nextElement()).getRowIndex()] != null) continue;
            String string = keyGenerator.nextKey();
            object10[object8.getRowIndex()] = string;
            object7 = string;
            while (problemI.getConstraint((String)object7) != null) {
                String string3 = keyGenerator.nextKey();
                object10[object8.getRowIndex()] = string3;
                object7 = string3;
            }
        }
        if (this._writeMetadata) {
            object8 = problemI.getMetadata();
            object7 = ((Metadata)object8).keys();
            while (object7.hasMoreElements()) {
                object6 = (String)object7.nextElement();
                object5 = ((Metadata)object8).get((String)object6, (String)object6);
                this.println("* Metadatum " + (String)object6 + " \"" + (String)object5 + "\"");
            }
        }
        this._header = "NAME";
        object8 = problemI.getMetadata().get("lp.name", null);
        if (object8 != null) {
            this._field2 = object8;
            this.printFields();
        }
        this._header = "ROWS";
        this.clear();
        this._field1 = "N";
        this._field2 = this._objectiveName;
        this.printFields();
        this.clear();
        object7 = problemI.constraints();
        while (object7.hasMoreElements()) {
            object6 = (ConstraintI)object7.nextElement();
            switch (object6.getType()) {
                case 10: {
                    this._field1 = "N";
                    break;
                }
                case 11: {
                    this._field1 = "L";
                    break;
                }
                case 13: {
                    this._field1 = "E";
                    break;
                }
                case 12: {
                    this._field1 = "G";
                    break;
                }
                case 14: {
                    this._field1 = "E";
                    break;
                }
                default: {
                    throw new MpError("Internal Error: unknown row type.");
                }
            }
            this._field2 = object10[object6.getRowIndex()];
            this.printFields();
        }
        this.clear();
        int n = 0;
        this._header = "COLUMNS";
        object5 = problemI.variables();
        while (object5.hasMoreElements()) {
            object4 = (VariableI)object5.nextElement();
            if (object4.getType() == 22 || object4.getType() == 23) {
                ++n;
                continue;
            }
            this._field2 = stringArray[object4.getColumnIndex()];
            if (!problemI.equals(object4.getObjectiveCoefficient(), 0.0)) {
                this._field3 = this._objectiveName;
                this._field4 = String.valueOf(object4.getObjectiveCoefficient());
                this.printFields();
            }
            object3 = matrixI.columnElements(object4.getColumnIndex());
            while (object3.hasMoreElements()) {
                object2 = (MatrixElementI)object3.nextElement();
                if (matrixI.equals(object2.getValue(), 0.0)) continue;
                this._field3 = object10[object2.getRowIndex()];
                this._field4 = String.valueOf(object2.getValue());
                this.printFields();
            }
        }
        if (n != 0) {
            this.clear();
            this._field2 = "MARK0000";
            this._field3 = "'MARKER'";
            this._field4 = "'INTORG'";
            this.printFields();
            this.clear();
            object4 = problemI.variables();
            while (object4.hasMoreElements()) {
                object3 = (VariableI)object4.nextElement();
                if (object3.getType() != 22 && object3.getType() != 23) continue;
                this._field2 = stringArray[object3.getColumnIndex()];
                if (!problemI.equals(object3.getObjectiveCoefficient(), 0.0)) {
                    this._field3 = this._objectiveName;
                    this._field4 = String.valueOf(object3.getObjectiveCoefficient());
                    this.printFields();
                }
                object2 = matrixI.columnElements(object3.getColumnIndex());
                while (object2.hasMoreElements()) {
                    object = (MatrixElementI)object2.nextElement();
                    if (problemI.equals(object.getValue(), 0.0)) continue;
                    this._field3 = object10[object.getRowIndex()];
                    this._field4 = String.valueOf(object.getValue());
                    this.printFields();
                }
            }
            this.clear();
            this._field2 = "MARK0000";
            this._field3 = "'MARKER'";
            this._field4 = "'INTEND'";
            this.printFields();
        }
        this.clear();
        this._header = "RHS";
        this._field2 = this._rightHandSideName;
        object4 = problemI.constraints();
        while (object4.hasMoreElements()) {
            object3 = (ConstraintI)object4.nextElement();
            double d = object3.getRightHandSide();
            if (object3.getType() == 14) {
                d = object3.getLowerRange();
            }
            if (problemI.equals(d, 0.0)) continue;
            this._field3 = object10[object3.getRowIndex()];
            this._field4 = String.valueOf(d);
            this.printFields();
        }
        this.clear();
        this._header = "BOUNDS";
        this._field2 = this._boundName;
        object3 = problemI.variables();
        while (object3.hasMoreElements()) {
            VariableI variableI = (VariableI)object3.nextElement();
            this._field3 = stringArray[variableI.getColumnIndex()];
            switch (variableI.getType()) {
                case 21: 
                case 22: {
                    if (variableI.getUpperBound() != Double.POSITIVE_INFINITY) {
                        this._field1 = "UP";
                        this._field4 = String.valueOf(variableI.getUpperBound());
                        this.printFields();
                    }
                    if (variableI.getLowerBound() == Double.NEGATIVE_INFINITY) {
                        this._field1 = "MI";
                        this._field4 = null;
                        this.printFields();
                        break;
                    }
                    if (problemI.equals(variableI.getLowerBound(), 0.0)) break;
                    this._field1 = "LO";
                    this._field4 = String.valueOf(variableI.getLowerBound());
                    this.printFields();
                    break;
                }
                case 23: {
                    if (this._useBooleanBound) {
                        this._field1 = "BV";
                        this._field4 = "1.0";
                        this.printFields();
                        break;
                    }
                    this._field1 = "UP";
                    this._field4 = "1.0";
                    this.printFields();
                    break;
                }
            }
        }
        this.clear();
        this._field2 = this._rangeName;
        this._header = "RANGES";
        Enumeration enumeration2 = problemI.constraints();
        while (enumeration2.hasMoreElements()) {
            double d;
            object = (ConstraintI)enumeration2.nextElement();
            if (object.getType() != 14 || problemI.equals(d = object.getUpperRange() - object.getLowerRange(), 0.0)) continue;
            if (d < 0.0) {
                throw new MpError("The constrain ranges are reversed.");
            }
            this._field3 = object10[object.getRowIndex()];
            this._field4 = String.valueOf(d);
            this.printFields();
        }
        this.flush();
    }
}

