/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.MainFrame;
import interfacing.NonEditableTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public class MueJPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -6939332491088413670L;
    private MainFrame frame;
    private JTable jTableForMue;
    private JTable jTableForActualMue;
    private JScrollPane scrollPaneForMue;
    private JScrollPane scrollPaneForActualMue;
    private JSplitPane splitPane;
    private JButton buttonUpdate;
    private JPanel buttonsPanel;
    final String iconsFolder = "Icons";
    Dimension d;

    public MueJPanel(MainFrame frame) {
        this.frame = frame;
        this.setLayout(new BorderLayout());
        this.jTableForMue = new JTable();
        this.jTableForActualMue = new JTable();
        this.jTableForMue.setSize(1, 1);
        this.jTableForActualMue.setSize(1, 1);
        this.scrollPaneForMue = new JScrollPane();
        this.scrollPaneForActualMue = new JScrollPane();
        this.scrollPaneForMue.setSize(1, 1);
        this.scrollPaneForActualMue.setSize(1, 1);
        this.splitPane = new JSplitPane(0, false, this.scrollPaneForMue, this.scrollPaneForActualMue);
        this.splitPane.setBounds(0, 0, 300, 700);
        this.buttonsPanel = new JPanel();
        this.buttonUpdate = new JButton("Update");
        this.buttonUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MueJPanel.this.refresh();
            }
        });
        this.jTableForActualMue.addMouseListener(this);
        this.jTableForMue.addMouseListener(this);
        this.buttonsPanel.add(this.buttonUpdate);
        this.buttonUpdate.setIcon(new ImageIcon("Icons/reload_22.png"));
        this.add((Component)this.buttonsPanel, "First");
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation(0.5);
        this.jTableForMue.getSelectionModel().setSelectionMode(0);
        this.jTableForMue.setColumnSelectionAllowed(true);
        this.jTableForActualMue.getSelectionModel().setSelectionMode(0);
        this.jTableForActualMue.setColumnSelectionAllowed(true);
    }

    public void repaint() {
        super.repaint();
        if (this.d != null) {
            this.scrollPaneForMue.setMaximumSize(this.d);
            this.scrollPaneForActualMue.setMaximumSize(this.d);
        }
    }

    public void refresh() {
        if (this.scrollPaneForActualMue == null) {
            return;
        }
        this.d = this.scrollPaneForActualMue.getSize();
        double[][] mue = this.frame.getMapper().constructMueMatrix();
        this.jTableForMue.setModel(new NonEditableTableModel(mue.length, mue[0].length));
        double[][] actualMue = this.frame.getMapper().constructActualMueMatrix();
        this.jTableForActualMue.setModel(new NonEditableTableModel(mue.length, mue[0].length));
        int i = 0;
        while (i < actualMue.length) {
            int j = 0;
            while (j < actualMue[i].length) {
                this.jTableForActualMue.setValueAt(actualMue[i][j], i, j);
                this.jTableForMue.setValueAt(mue[i][j], i, j);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < actualMue[0].length) {
            this.jTableForActualMue.getColumnModel().getColumn(j).setHeaderValue(String.valueOf(j + 1));
            this.jTableForMue.getColumnModel().getColumn(j).setHeaderValue(String.valueOf(j + 1));
            ++j;
        }
        this.scrollPaneForMue.setViewportView(this.jTableForMue);
        this.scrollPaneForActualMue.setViewportView(this.jTableForActualMue);
        this.splitPane.setDividerLocation(0.5);
    }

    public void mouseClicked(MouseEvent e) {
        int j;
        int i;
        if (e.getSource() == this.jTableForActualMue) {
            i = this.jTableForActualMue.getSelectedRow();
            j = this.jTableForActualMue.getSelectedColumn();
            this.jTableForMue.getSelectionModel().setSelectionInterval(i, i);
            this.jTableForMue.getColumnModel().getSelectionModel().setSelectionInterval(j, j);
        }
        if (e.getSource() == this.jTableForMue) {
            i = this.jTableForMue.getSelectedRow();
            j = this.jTableForMue.getSelectedColumn();
            this.jTableForActualMue.getSelectionModel().setSelectionInterval(i, i);
            this.jTableForActualMue.getColumnModel().getSelectionModel().setSelectionInterval(j, j);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

