/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.MainFrame;
import interfacing.PropertiesJPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import mapping.FCFS_MS;
import mapping.Gcu_MS;
import mapping.LPAS_DG_MS;
import mapping.MET_MS;
import mapping.NREP_MS;
import mapping.SLQ_MS;

public class SystemLevelParametersJPanel
extends JPanel
implements ActionListener,
AncestorListener {
    private static final long serialVersionUID = 2968259505414678075L;
    private JComboBox mappingSchemeCB = new JComboBox();
    private static final int LPAS_DG = 0;
    private static final int GCU = 1;
    private static final int MET = 2;
    private static final int FCFS = 3;
    private static final int SLQ = 4;
    private static final int NREP = 5;
    private JButton applyBN = new JButton("Apply");
    private String[] labels = new String[]{"Minutes Per Time Units", "Mean Time to Repair", "Mean Time to Fail", "Mapping Scheme", "Time Resolution", "Artificial Failures", "Time-out After (times)"};
    private String[] tips = new String[]{"In MGST, instead of using minutes or seconds, Time Units are used. This field defines how many minutes are in one time unit. For example, if 2.0 was set, then every time unit in the actual testing will take 2 minutes.", "This value determines the mean of the failure period used to generate artificial traces.", "This value determines the mean of the up time periods used to generate artificial traces.", "The Mapping Scheme to be used in the test.", "This time determintes the period after which the puller sends an update for the mapper. ", "This determines if failures are simulated or not.", "To declare a job as timed-out one, a time of (n * (time esitmated for The Job To be completed)) must elapse. This paremeter determines n"};
    private PropertiesJPanel propPanel;
    private MainFrame frame;
    boolean firstTime = true;

    public SystemLevelParametersJPanel(MainFrame frame) {
        this.frame = frame;
        this.propPanel = new PropertiesJPanel(this.labels, this.tips);
        this.mappingSchemeCB.addItem(new String("LPAS_DG"));
        this.mappingSchemeCB.addItem(new String("Gcu"));
        this.mappingSchemeCB.addItem(new String("MET"));
        this.mappingSchemeCB.addItem(new String("FCFS"));
        this.mappingSchemeCB.addItem(new String("SLQ"));
        this.propPanel.replaceValueComponent(3, this.mappingSchemeCB);
        this.propPanel.replaceValueComponent(5, new JCheckBox());
        this.applyBN.addActionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 10;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        this.add((Component)this.propPanel, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        this.add((Component)this.applyBN, gbConstraints);
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridy = 2;
        this.add(Box.createVerticalGlue(), gbConstraints);
        this.addAncestorListener(this);
    }

    public void repaint() {
        if (this.propPanel == null) {
            return;
        }
        if (this.hasUserModified()) {
            return;
        }
        this.refreshValues();
    }

    public void refreshValues() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        try {
            this.propPanel.setValue(0, String.valueOf(this.frame.getMapper().getTimeUnitInMinutes()));
            this.propPanel.setValue(1, String.valueOf(df.format(this.frame.getMapper().getFailurePeriodsMean())));
            this.propPanel.setValue(2, String.valueOf(df.format(this.frame.getMapper().getUpTimePeriodsMean())));
            this.propPanel.setValue(3, this.frame.getMapper().getMappingScheme().getDescription());
            this.propPanel.setValue(4, String.valueOf(this.frame.getMapper().getTimeResolution()));
            this.propPanel.setValue(5, String.valueOf(this.frame.getMapper().isTimeOutActive()));
            this.propPanel.setValue(6, String.valueOf(this.frame.getMapper().getTimeOutFactor()));
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            this.propPanel.setValue(0, "0");
            this.propPanel.setValue(1, "0");
            this.propPanel.setValue(2, "0");
            this.propPanel.setValue(3, "0");
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.applyInput();
    }

    public void applyInput() {
        String[] values = this.propPanel.getValues();
        double timeUnit = 0.0;
        double periodMean = 0.0;
        double interPeriodsMean = 0.0;
        int timeResolution = 0;
        boolean aritfitialFailurAndTimeOutsActive = false;
        double timeOutFactor = 1.0;
        try {
            timeUnit = Double.parseDouble(values[0]);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.frame, "Time Unit should be a number.", "Error", 0);
            return;
        }
        try {
            periodMean = Double.parseDouble(values[1]);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.frame, String.valueOf(this.labels[1]) + " should be a number.", "Error", 0);
            return;
        }
        try {
            interPeriodsMean = Double.parseDouble(values[2]);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.frame, String.valueOf(this.labels[2]) + " should be a number.", "Error", 0);
            return;
        }
        switch (this.mappingSchemeCB.getSelectedIndex()) {
            case 0: {
                this.frame.getMapper().setMappingScheme(new LPAS_DG_MS(this.frame.getMapper()));
                break;
            }
            case 1: {
                this.frame.getMapper().setMappingScheme(new Gcu_MS(this.frame.getMapper()));
                break;
            }
            case 2: {
                this.frame.getMapper().setMappingScheme(new MET_MS(this.frame.getMapper()));
                break;
            }
            case 3: {
                this.frame.getMapper().setMappingScheme(new FCFS_MS(this.frame.getMapper()));
                break;
            }
            case 4: {
                this.frame.getMapper().setMappingScheme(new SLQ_MS(this.frame.getMapper()));
                break;
            }
            case 5: {
                this.frame.getMapper().setMappingScheme(new NREP_MS(this.frame.getMapper()));
            }
        }
        try {
            timeResolution = Integer.parseInt(values[4]);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.frame, "Time resolution should be an integer.", "Error", 0);
            return;
        }
        if (values[5].equalsIgnoreCase("true")) {
            aritfitialFailurAndTimeOutsActive = true;
        }
        if (aritfitialFailurAndTimeOutsActive) {
            try {
                timeOutFactor = Double.parseDouble(values[6]);
                if (timeOutFactor < 1.5) {
                    JOptionPane.showMessageDialog(this.frame, "Timeout fold should be a number larger or equal 1.5.", "Error", 0);
                    return;
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.frame, "Timeout fold should be a number.", "Error", 0);
                return;
            }
        }
        this.frame.getMapper().setTimeUnitInMinutes(timeUnit);
        this.frame.getMapper().setTimeResolution(timeResolution);
        this.frame.getMapper().setFailurePeriodsMean(periodMean);
        this.frame.getMapper().setUpTimePeriodsMean(interPeriodsMean);
        this.frame.getMapper().fillAllFailureTraces(periodMean, interPeriodsMean);
        this.frame.getMapper().setTimeOutActive(aritfitialFailurAndTimeOutsActive);
        this.frame.getMapper().setArtificialFailuresActive(aritfitialFailurAndTimeOutsActive);
        this.frame.getMapper().setTimeOutFactor(timeOutFactor);
    }

    public void ancestorAdded(AncestorEvent arg0) {
    }

    public void ancestorMoved(AncestorEvent arg0) {
    }

    public void ancestorRemoved(AncestorEvent arg0) {
        if (this.hasUserModified()) {
            this.frame.serversAndJobsClassesTablesTabbedPane.setSelectedIndex(0);
            this.frame.tabbedPane.setSelectedIndex(0);
            int result = JOptionPane.showConfirmDialog(this, "You have modified the parameters, do you want to apply changes?", "Apply", 0);
            if (result == 0) {
                this.applyInput();
            }
            if (result == 1) {
                this.refreshValues();
            }
        }
    }

    public boolean hasUserModified() {
        if (this.firstTime) {
            this.firstTime = false;
            return false;
        }
        if (Double.parseDouble(this.propPanel.getValue(0)) != this.frame.getMapper().getTimeUnitInMinutes()) {
            return true;
        }
        if (Double.parseDouble(this.propPanel.getValue(1)) != this.frame.getMapper().getFailurePeriodsMean()) {
            return true;
        }
        if (Double.parseDouble(this.propPanel.getValue(2)) != this.frame.getMapper().getUpTimePeriodsMean()) {
            return true;
        }
        if (!this.propPanel.getValue(3).equalsIgnoreCase(this.frame.getMapper().getMappingScheme().getDescription())) {
            return true;
        }
        if (Double.parseDouble(this.propPanel.getValue(4)) != (double)this.frame.getMapper().getTimeResolution()) {
            return true;
        }
        if (!String.valueOf(this.frame.getMapper().isTimeOutActive()).equalsIgnoreCase(this.propPanel.getValue(5))) {
            return true;
        }
        return this.frame.getMapper().isTimeOutActive() && Double.parseDouble(this.propPanel.getValue(6)) != this.frame.getMapper().getTimeOutFactor();
    }
}

