/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import mapping.Mapper;
import mapping.MappingScheme;
import mapping.NREP_MS_Thread;
import mapping.data.IDsQueue;
import mapping.data.Job;

public class NREP_MS
extends MappingScheme {
    private static final long serialVersionUID = 6935102166481580800L;
    private IDsQueue<Long> serviceQueue;
    private NREP_MS_Thread nrep_ms_thread;
    private long[] result;
    static final int NO_JOBS = -100;

    public NREP_MS(Mapper mapper) {
        super(mapper);
        this.setDescription("NREP");
    }

    public void startMappingScheme() {
        this.serviceQueue = new IDsQueue();
        this.nrep_ms_thread = new NREP_MS_Thread(this);
        this.nrep_ms_thread.startThread();
    }

    public void stopMappingScheme() {
        this.nrep_ms_thread.stopThread();
    }

    protected void mapJob(Job job) {
        this.serviceQueue.enqueue(job.getIndex());
    }

    public void handleJobTimeOut(long jobID) {
        this.getMapper().getJobsTable().setTimedOut(jobID, true);
        this.getMapper().getJobsTable().setJobServer(jobID, null);
        this.getMapper().resubmitJob((Job)this.getMapper().getJobsTable().get(jobID));
    }

    public void serverIsDown(int serverID) {
    }

    public void serverIsUp(int serverID) {
    }

    public boolean failuresOccur() {
        boolean fail = false;
        int i = 0;
        while (i < this.result.length) {
            if (this.result[i] < 0L) {
                fail = true;
            }
            ++i;
        }
        return fail;
    }

    protected int sendJobForServer(int[] serverID) {
        this.result = new long[serverID.length];
        if (this.serviceQueue.isEmpty()) {
            return -100;
        }
        long jobID = this.serviceQueue.peak();
        int i = 0;
        while (i < serverID.length) {
            this.result[i] = this.getMapper().sendJob(jobID, serverID[i]);
            ++i;
        }
        this.getMapper().setcancelFlag(true, serverID, jobID);
        if (!this.failuresOccur()) {
            this.serviceQueue.dequeue();
            return 1;
        }
        return -1;
    }
}

