/*
 * Decompiled with CFR 0.152.
 */
package mapping.data;

import java.io.Serializable;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;
import mapping.Mapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDsQueue<Item>
extends AbstractTableModel
implements Serializable {
    private static final long serialVersionUID = -7905134392927161008L;
    private LinkedList<Item> list = new LinkedList();
    private Mapper mapper;

    public IDsQueue() {
    }

    public IDsQueue(Mapper mapper) {
        this.mapper = mapper;
    }

    public void printServers() {
        int i = 0;
        while (i < this.list.size()) {
            System.out.println(String.valueOf(this.mapper.getServer((Integer)this.list.get(i)).getHostName()) + " number of tasks: " + this.mapper.getServer((Integer)this.list.get(i)).getNumberOfActiveJobs());
            ++i;
        }
        System.out.println("-----------------------\n");
    }

    public synchronized void enqueue(Item item) {
        if (!this.list.contains(item)) {
            this.list.add(item);
        }
    }

    public synchronized Item dequeue() {
        return this.list.remove();
    }

    public synchronized Item peak() {
        return this.list.get(0);
    }

    public synchronized Item getVal(int row) {
        return this.list.get(row);
    }

    public synchronized Item remove(Item item) {
        int i = 0;
        while (i < this.list.size()) {
            if (item.equals(this.list.get(i))) {
                return this.list.remove(i);
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    public synchronized void print() {
        if (this.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.list.size()) {
            System.out.println(this.list.get(i));
            ++i;
        }
    }

    public synchronized void advanceInRoundRobinFashion() {
        if (this.list.size() < 2) {
            return;
        }
        this.enqueue(this.dequeue());
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public String getColumnName(int column) {
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.mapper == null) {
            return this.list.get(row);
        }
        return this.mapper.getServer((Integer)this.list.get(row)).getHostName();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    public static void main(String[] args) {
        IDsQueue<Integer> queue = new IDsQueue<Integer>();
        queue.enqueue(1);
        queue.enqueue(7);
        queue.enqueue(20);
        queue.enqueue(12);
        queue.enqueue(12);
        queue.print();
        queue.advanceInRoundRobinFashion();
        System.out.println("-----");
        queue.print();
        queue.advanceInRoundRobinFashion();
        System.out.println("-----");
        queue.print();
        queue.advanceInRoundRobinFashion();
        System.out.println("-----");
        queue.print();
        queue.advanceInRoundRobinFashion();
        System.out.println("-----");
        queue.print();
        queue.advanceInRoundRobinFashion();
        System.out.println("-----");
        queue.print();
    }
}

