/*
 * Decompiled with CFR 0.152.
 */
package pulling.executing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import pulling.executing.CPUUsageUpdater_BuiltIn;
import pulling.executing.ServerSideExecuter;

public class ServerSideExecuter_BuiltIn
extends ServerSideExecuter
implements Runnable {
    private static final long serialVersionUID = 1L;
    private boolean alive = true;
    private Thread thisThread;
    private Hashtable<Long, JobInfo> executerJobTable;
    private int serverPort = 37935;
    private String hostName;
    private String password = "";
    private int serverID;
    private String mapperHostName;
    private int completionServerPort = 37931;
    private double availability = 1.0;
    private int percent;
    private double dateSubmitted = 0.0;
    private String dateStarted = null;
    private String dateStopped = null;
    private static long ExecutionLayerIDCounter = 1L;
    private double IdlePercent = 1.0;
    ServerSocket serverSocket = null;
    Socket socket = null;
    DataInputStream in = null;
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    Socket mapperSocket = null;
    DataOutputStream out = null;

    public ServerSideExecuter_BuiltIn(String mapperHostName) {
        this.executerJobTable = new Hashtable(2000);
        this.setMapperHostName(mapperHostName);
        try {
            this.setHostName(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostname) {
        this.hostName = hostname;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getServerID() {
        return this.serverID;
    }

    public void setServerID(int serverID) {
        this.serverID = serverID;
    }

    public double getAvailability() {
        return this.availability;
    }

    public void setAvailability(double avail) {
        this.availability = avail;
    }

    public String getMapperHostName() {
        return this.mapperHostName;
    }

    public void setMapperHostName(String mapperHostName) {
        this.mapperHostName = mapperHostName;
    }

    public int getCompletionServerPort() {
        return this.completionServerPort;
    }

    public void setCompletionServerPort(int completionServerPort) {
        this.completionServerPort = completionServerPort;
    }

    public void setIdlePercent(double Percent) {
        this.IdlePercent = Percent;
    }

    public double getIdlePercent() {
        return this.IdlePercent;
    }

    public void startExecuter() {
        this.thisThread = new Thread(this);
        this.thisThread.start();
        new Thread(new CPUUsageUpdater_BuiltIn(this)).start();
    }

    public void stopExecuter() {
        boolean wasAlive = this.isAlive();
        this.setAlive(false);
        if (wasAlive) {
            this.thisThread.interrupt();
            this.thisThread = null;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public long deleteJob(long id, String hostname, String password) {
        return 0L;
    }

    public String getDateStarted(long id, String hostname, String password) {
        return this.dateStarted;
    }

    public String getDateStopped(long id, String hostname, String password) {
        return this.dateStopped;
    }

    public double getDateSubmitted(long id, String hostname, String password) {
        return this.dateSubmitted;
    }

    public String getJobStatus(long id, String hostname, String password) {
        return "The current percent completed is : " + this.percent;
    }

    public double getPercentageDone(long id, String hostname, String password) {
        return this.percent;
    }

    public long stopJob(long id, String hostname, String password) {
        return 0L;
    }

    public long submitLoopJob(String hostName, String password, String workingDirectory, long iter, double ratio) {
        return 0L;
    }

    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.getServerPort());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        while (this.isAlive()) {
            int executionTime = 0;
            String ratioString = "";
            int serverID = 0;
            long mapperJobID = 0L;
            double ratio = 0.0;
            try {
                int r;
                this.socket = this.serverSocket.accept();
                if (!this.isAlive()) {
                    return;
                }
                this.in = new DataInputStream(this.socket.getInputStream());
                while ((r = this.in.read()) != -1 && r != 35) {
                    if ((char)r - 48 < 0) continue;
                    executionTime = 10 * executionTime + ((char)r - 48);
                }
                while ((r = this.in.read()) != -1 && r != 35) {
                    ratioString = String.valueOf(ratioString) + (char)r;
                }
                while ((r = this.in.read()) != -1 && r != 35) {
                    if ((char)r - 48 < 0) continue;
                    serverID = 10 * serverID + ((char)r - 48);
                }
                while ((r = this.in.read()) != -1 && r != 35) {
                    if ((char)r - 48 >= 0) {
                        mapperJobID = 10L * mapperJobID + (long)((char)r - 48);
                    }
                    this.dateSubmitted = new GregorianCalendar().getTimeInMillis();
                }
                ratio = Double.parseDouble(ratioString);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.setServerID(serverID);
            this.executerJobTable.put(ExecutionLayerIDCounter, new JobInfo(ExecutionLayerIDCounter, mapperJobID));
            this.dateStarted = new GregorianCalendar().getTime().toString();
            System.out.println("Job: " + mapperJobID + " started at " + this.dateStarted);
            this.executeJob(executionTime, ratio, ExecutionLayerIDCounter);
            this.dateStopped = new GregorianCalendar().getTime().toString();
            System.out.println("Job: " + mapperJobID + " completed at " + this.dateStopped);
            ++ExecutionLayerIDCounter;
        }
    }

    public void executeJob(int executionTime, double ratio, long ExecutionLayerID) {
        System.out.println("executionTime : " + executionTime + " Ratio : " + ratio);
        this.executerJobTable.get((Object)Long.valueOf((long)ExecutionLayerID)).dateStarted = new GregorianCalendar();
        double firstPercent = 1.0;
        int JobTime = (int)((double)executionTime * ratio);
        int SleepTime = 100;
        while (JobTime > 0) {
            try {
                firstPercent = this.getIdlePercent();
                Thread.sleep(SleepTime);
                JobTime -= (int)((double)SleepTime * (this.avg(this.getIdlePercent(), firstPercent) * this.getAvailability()));
            }
            catch (InterruptedException e) {
                System.out.println("Job has not completed");
            }
        }
        this.executerJobTable.get((Object)Long.valueOf((long)ExecutionLayerID)).dateStopped = new GregorianCalendar();
        this.notifyMapper(ExecutionLayerID);
    }

    public double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    public void notifyMapper(long ExecutionLayerID) {
        try {
            try {
                String dateStarted = this.formatter.format(this.executerJobTable.get((Object)Long.valueOf((long)ExecutionLayerID)).dateStarted.getTime());
                String dateDone = this.formatter.format(this.executerJobTable.get((Object)Long.valueOf((long)ExecutionLayerID)).dateStopped.getTime());
                String message = String.valueOf(this.formatter.format(new GregorianCalendar().getTime())) + "#" + this.getServerID() + "#" + this.getHostName() + "#" + this.executerJobTable.get((Object)Long.valueOf((long)ExecutionLayerID)).mapperJobID + "#" + ExecutionLayerID + "#" + dateStarted + "#" + dateDone;
                this.mapperSocket = new Socket(this.getMapperHostName(), this.getCompletionServerPort());
                this.out = new DataOutputStream(this.mapperSocket.getOutputStream());
                this.out.writeBytes(message);
                this.dateSubmitted = 0.0;
                this.dateStarted = null;
                this.dateStopped = null;
            }
            catch (UnknownHostException e) {
                System.err.println("Don't know about mapper: " + this.getMapperHostName());
                try {
                    if (this.out != null) {
                        this.out.flush();
                        this.out.close();
                    }
                    if (this.mapperSocket != null) {
                        this.mapperSocket.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                System.err.println("FinishedThread.run: Couldn't Connect with the socket  the connection to: " + this.getMapperHostName() + " did not function properly. Make sure Completion Server is listening at " + this.getCompletionServerPort());
                try {
                    if (this.out != null) {
                        this.out.flush();
                        this.out.close();
                    }
                    if (this.mapperSocket != null) {
                        this.mapperSocket.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
                if (this.mapperSocket != null) {
                    this.mapperSocket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class JobInfo {
        long ExecutionLayerJobID;
        long mapperJobID;
        GregorianCalendar dateStarted;
        GregorianCalendar dateStopped;
        String Result;

        public JobInfo(long ExecutionLayerJobID, long mapperJobID) {
            this.ExecutionLayerJobID = ExecutionLayerJobID;
            this.mapperJobID = mapperJobID;
        }
    }
}

