/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.geo;

import drasys.or.geom.GeomError;
import drasys.or.geom.RangeI;
import drasys.or.geom.geo.Geo;
import drasys.or.geom.geo.Point;
import drasys.or.geom.geo.PointI;
import java.io.Serializable;

public class Range
extends Geo
implements drasys.or.geom.geo.RangeI,
Serializable {
    Point _southwest;
    Point _northeast;

    public Range(double d, double d2, double d3, double d4) {
        double d5 = Math.max(d2, d4);
        double d6 = Math.min(d2, d4);
        this._southwest = new Point(d, Math.min(d5, d6));
        this._northeast = new Point(d3, Math.max(d5, d6));
    }

    public Range(PointI pointI, PointI pointI2) {
        this(pointI.longitude(), pointI.latitude(), pointI2.longitude(), pointI2.latitude());
    }

    public Range(drasys.or.geom.geo.RangeI rangeI) {
        this(rangeI.southwest(), rangeI.northeast());
    }

    public PointI bound(PointI pointI) {
        if (this.includes(pointI)) {
            return pointI;
        }
        double d = pointI.longitude();
        double d2 = pointI.latitude();
        if (d2 < this.south()) {
            d2 = this.south();
        } else if (d2 > this.north()) {
            d2 = this.north();
        }
        d = Math.abs(Math.IEEEremainder(d - this.west(), 360.0)) < Math.abs(Math.IEEEremainder(d - this.east(), 360.0)) ? this.west() : this.east();
        return new Point(d, d2);
    }

    public drasys.or.geom.PointI boundPoint(drasys.or.geom.PointI pointI) {
        return this.bound((PointI)pointI);
    }

    public PointI centroid() {
        double d = this.west() < this.east() ? this.east() : this.east() + 360.0;
        return new Point((d + this.west()) * 0.5, (this.north() + this.south()) * 0.5);
    }

    public double distanceProxyTo(PointI pointI) {
        return pointI.distanceProxyTo(this.nearestPointTo(pointI));
    }

    public double distanceTo(PointI pointI) {
        return pointI.distanceTo(this.nearestPointTo(pointI));
    }

    public double east() {
        return this._northeast.longitude();
    }

    public boolean equals(Object object) {
        if (!(object instanceof drasys.or.geom.geo.RangeI)) {
            return false;
        }
        if (!this._southwest.equals(((drasys.or.geom.geo.RangeI)object).southwest())) {
            return false;
        }
        return this._northeast.equals(((drasys.or.geom.geo.RangeI)object).northeast());
    }

    public RangeI getExpandedRange(drasys.or.geom.PointI pointI) {
        if (!(pointI instanceof PointI)) {
            throw new GeomError("The point must be in the same coordinate system as the range.");
        }
        if (this.includes(pointI)) {
            return this;
        }
        PointI pointI2 = (PointI)pointI;
        double d = this.north();
        double d2 = this.south();
        double d3 = this.east();
        double d4 = this.west();
        double d5 = Math.abs(pointI2.latitude() - d);
        double d6 = Math.abs(pointI2.latitude() - d2);
        double d7 = Math.abs(Math.IEEEremainder(pointI2.longitude() - d4, 360.0));
        double d8 = Math.abs(Math.IEEEremainder(pointI2.longitude() - d3, 360.0));
        if (d5 < d6) {
            d = pointI2.longitude();
        } else {
            d2 = pointI2.longitude();
        }
        if (d8 < d7) {
            d3 = pointI2.longitude();
        } else {
            d4 = pointI2.longitude();
        }
        return new Range(d4, d2, d3, d);
    }

    public drasys.or.geom.PointI getMax() {
        return this.northeast();
    }

    public drasys.or.geom.PointI getMin() {
        return this.southwest();
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.north()) + Double.doubleToLongBits(this.south()) + Double.doubleToLongBits(this.east()) + Double.doubleToLongBits(this.west()));
    }

    public boolean includes(drasys.or.geom.PointI pointI) {
        if (!(pointI instanceof PointI)) {
            throw new GeomError("The point must be in the same coordinate system as the range.");
        }
        PointI pointI2 = (PointI)pointI;
        if (pointI2.latitude() > this.north()) {
            return false;
        }
        if (pointI2.latitude() < this.south()) {
            return false;
        }
        if (this.west() < this.east()) {
            if (pointI2.longitude() < this.west()) {
                return false;
            }
            if (pointI2.longitude() > this.east()) {
                return false;
            }
        } else if (pointI2.longitude() < this.west() && pointI2.longitude() > this.east()) {
            return false;
        }
        return true;
    }

    public PointI nearestPointTo(PointI pointI) {
        PointI pointI2 = this.bound(pointI);
        if (pointI2 != pointI) {
            return pointI2;
        }
        double d = pointI.longitude();
        double d2 = pointI.latitude();
        Point point = new Point(this.west(), d2);
        Point point2 = new Point(this.east(), d2);
        Point point3 = new Point(d, this.north());
        Point point4 = new Point(d, this.south());
        double d3 = point.distanceProxyTo(pointI);
        double d4 = point.distanceProxyTo(pointI);
        double d5 = point.distanceProxyTo(pointI);
        double d6 = point.distanceProxyTo(pointI);
        double d7 = Math.min(Math.min(d3, d4), Math.min(d5, d6));
        if (d3 == d7) {
            return point;
        }
        if (d4 == d7) {
            return point2;
        }
        if (d5 == d7) {
            return point3;
        }
        return point4;
    }

    public double north() {
        return this._northeast.latitude();
    }

    public PointI northeast() {
        return this._northeast;
    }

    public drasys.or.geom.geo.RangeI range() {
        return this;
    }

    public double south() {
        return this._southwest.latitude();
    }

    public PointI southwest() {
        return this._southwest;
    }

    public String toString() {
        return "geo.Range{" + this._southwest.toString() + "; " + this._northeast.toString() + "}";
    }

    public double west() {
        return this._southwest.longitude();
    }
}

