/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph;

import drasys.or.graph.AddVertexI;
import drasys.or.graph.DuplicateVertexException;
import drasys.or.graph.EdgeI;
import drasys.or.graph.Graph;
import drasys.or.graph.VertexI;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class BaseGraph
extends Graph
implements AddVertexI {
    int _changeCount = 0;
    int _sizeOfEdges = 0;
    int _sizeOfDirectedEdges = 0;
    Hashtable _vertexHashtable;

    public BaseGraph() {
        this._vertexHashtable = new Hashtable();
    }

    public BaseGraph(int n) {
        this._vertexHashtable = new Hashtable(n);
    }

    public VertexI addVertex(VertexI vertexI) throws DuplicateVertexException {
        return this.addVertex(vertexI.getKey(), vertexI.getValue());
    }

    public VertexI addVertex(Object object) throws DuplicateVertexException {
        return this.addVertex(object, null);
    }

    public VertexI addVertex(Object object, Object object2) throws DuplicateVertexException {
        if (this._vertexHashtable.get(object) != null) {
            throw new DuplicateVertexException();
        }
        VertexI vertexI = this.newVertex(object, object2);
        this._vertexHashtable.put(object, vertexI);
        ++this._changeCount;
        return vertexI;
    }

    public void ensureVertexCapacity(int n) {
    }

    private EdgeI findEdge(Object object, Object object2, Object object3) {
        VertexI vertexI = (VertexI)this._vertexHashtable.get(object);
        if (vertexI == null) {
            return null;
        }
        VertexI vertexI2 = (VertexI)this._vertexHashtable.get(object2);
        if (vertexI2 == null) {
            return null;
        }
        return this.findEdge(vertexI, vertexI2, object3);
    }

    public int getChangeCount() {
        return this._changeCount;
    }

    public VertexI getVertex(Object object) {
        return (VertexI)this._vertexHashtable.get(object);
    }

    protected abstract VertexI newVertex(Object var1, Object var2);

    public void removeAllVertices() {
        this._sizeOfEdges = 0;
        this._vertexHashtable.clear();
    }

    public int sizeOfDirectedEdges() {
        return this._sizeOfDirectedEdges;
    }

    public int sizeOfEdges() {
        return this._sizeOfEdges;
    }

    public int sizeOfVertices() {
        return this._vertexHashtable.size();
    }

    public Enumeration vertices() {
        return this._vertexHashtable.elements();
    }
}

