/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.mp;

import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.RealContainer;
import drasys.or.matrix.SizableMatrixI;
import drasys.or.matrix.SparseMatrix;
import drasys.or.mp.Constraint;
import drasys.or.mp.ConstraintI;
import drasys.or.mp.DuplicateException;
import drasys.or.mp.MpError;
import drasys.or.mp.NotFoundException;
import drasys.or.mp.ProblemI;
import drasys.or.mp.SizableProblemI;
import drasys.or.mp.Variable;
import drasys.or.mp.VariableI;
import drasys.or.util.KeyGenerator;
import drasys.or.util.Metadata;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Problem
extends RealContainer
implements SizableProblemI,
Serializable {
    private String _name;
    private boolean _isMaximize = true;
    private Metadata _metadata = new Metadata();
    private Vector _variables = null;
    private Vector _constraints = null;
    private Hashtable _variableIndex = null;
    private Hashtable _constraintIndex = null;
    SizableMatrixI _coefficients = null;

    public Problem(int n, int n2) {
        this._variables = new Vector(n2);
        this._constraints = new Vector(n);
        this._variableIndex = new Hashtable(n2);
        this._constraintIndex = new Hashtable(n);
        this._coefficients = new SparseMatrix(0, 0);
    }

    public Problem(int n, int n2, SizableMatrixI sizableMatrixI) {
        this._variables = new Vector(n2);
        this._constraints = new Vector(n);
        this._variableIndex = new Hashtable(n2);
        this._constraintIndex = new Hashtable(n);
        this._coefficients = sizableMatrixI;
    }

    public Enumeration coefficients() {
        return this._coefficients.elements();
    }

    public Enumeration constraints() {
        return this._constraints.elements();
    }

    public boolean equals(Object object) {
        Object object2;
        Object object3;
        if (!(object instanceof ProblemI)) {
            return false;
        }
        ProblemI problemI = (ProblemI)object;
        if (problemI.sizeOfVariables() != this.sizeOfVariables()) {
            return false;
        }
        if (problemI.sizeOfConstraints() != this.sizeOfConstraints()) {
            return false;
        }
        Enumeration enumeration = problemI.variables();
        while (enumeration.hasMoreElements()) {
            object3 = (VariableI)enumeration.nextElement();
            object2 = (Variable)this._variables.elementAt(object3.getColumnIndex());
            if (((Variable)object2).equals(object3)) continue;
            return false;
        }
        object3 = problemI.constraints();
        while (object3.hasMoreElements()) {
            object2 = (ConstraintI)object3.nextElement();
            Constraint constraint = (Constraint)this._constraints.elementAt(object2.getRowIndex());
            if (constraint.equals(object2)) continue;
            return false;
        }
        return true;
    }

    public double getCoefficientAt(int n, int n2) {
        return this._coefficients.elementAt(n, n2);
    }

    public double getCoefficientAt(String string, String string2) throws NotFoundException {
        Variable variable = (Variable)this._variableIndex.get(string2);
        if (variable == null) {
            throw new NotFoundException("Can't find variable: " + string2);
        }
        Constraint constraint = (Constraint)this._constraintIndex.get(string);
        if (constraint == null) {
            throw new NotFoundException("Can't find constraint: " + string);
        }
        return this._coefficients.elementAt(constraint._rowIndex, variable._columnIndex);
    }

    public MatrixI getCoefficientMatrix() {
        return this._coefficients;
    }

    public ConstraintI getConstraint(int n) {
        return (ConstraintI)this._constraints.elementAt(n);
    }

    public ConstraintI getConstraint(String string) {
        return (ConstraintI)this._constraintIndex.get(string);
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public VariableI getVariable(int n) {
        return (VariableI)this._variables.elementAt(n);
    }

    public VariableI getVariable(String string) {
        return (VariableI)this._variableIndex.get(string);
    }

    public void maskNames(Enumeration enumeration) {
        Object object;
        if (enumeration == null) {
            enumeration = new KeyGenerator(8);
        }
        String[] stringArray = new String[this._variables.size()];
        int n = 0;
        while (n < stringArray.length) {
            if (!enumeration.hasMoreElements()) {
                throw new MpError("Names doesn't have enough elements.");
            }
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        String[] stringArray2 = new String[this._constraints.size()];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if (!enumeration.hasMoreElements()) {
                throw new MpError("Names doesn't have enough elements.");
            }
            stringArray2[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        this._variableIndex = new Hashtable(this._variables.size());
        int n3 = 0;
        Enumeration enumeration2 = this._variables.elements();
        while (enumeration2.hasMoreElements()) {
            object = (Variable)enumeration2.nextElement();
            ((Variable)object)._name = stringArray[n3];
            this._variableIndex.put(((Variable)object)._name, object);
            ++n3;
        }
        this._constraintIndex = new Hashtable(this._constraints.size());
        n3 = 0;
        object = this._constraints.elements();
        while (object.hasMoreElements()) {
            Constraint constraint = (Constraint)object.nextElement();
            constraint._name = stringArray2[n3];
            this._constraintIndex.put(constraint._name, constraint);
            ++n3;
        }
    }

    public ConstraintI newConstraint(String string) throws DuplicateException {
        Constraint constraint = null;
        if (string != null) {
            constraint = (Constraint)this._constraintIndex.get(string);
        }
        if (constraint != null) {
            throw new DuplicateException("The constraint exists: " + string);
        }
        constraint = new Constraint(this._constraints.size(), string);
        this._constraintIndex.put(string, constraint);
        this._constraints.addElement(constraint);
        this._coefficients.addRow(null);
        return constraint;
    }

    public VariableI newVariable(String string) throws DuplicateException {
        Variable variable = null;
        if (string != null) {
            variable = (Variable)this._variableIndex.get(string);
        }
        if (variable != null) {
            throw new DuplicateException("The variable exists: " + string);
        }
        variable = new Variable(this._variables.size(), string);
        this._variableIndex.put(string, variable);
        this._variables.addElement(variable);
        this._coefficients.addColumn(null);
        return variable;
    }

    public int relaxInteger() {
        int n = 0;
        Enumeration enumeration = this._variables.elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.getType() == 22) {
                variable.setType((byte)21);
                ++n;
                continue;
            }
            if (variable.getType() != 23) continue;
            variable.setType((byte)21);
            variable.setLowerBound(0.0);
            variable.setUpperBound(1.0);
            ++n;
        }
        return n;
    }

    public void setCapacity(int n, int n2) {
        this._variables.ensureCapacity(n2);
        this._constraints.ensureCapacity(n);
        this._coefficients.setCapacity(n, n2);
    }

    public void setCoefficientAt(int n, int n2, double d) {
        this._coefficients.setElementAt(n, n2, d);
    }

    public void setCoefficientAt(String string, String string2, double d) throws NotFoundException {
        Variable variable = (Variable)this._variableIndex.get(string2);
        if (variable == null) {
            throw new NotFoundException("Can't find variable: " + string2);
        }
        Constraint constraint = (Constraint)this._constraintIndex.get(string);
        if (constraint == null) {
            throw new NotFoundException("Can't find constraint: " + string);
        }
        this._coefficients.setElementAt(constraint._rowIndex, variable._columnIndex, d);
    }

    public int sizeOfCoefficients() {
        return this._coefficients.sizeOfElements();
    }

    public int sizeOfConstraints() {
        return this._constraints.size();
    }

    public int sizeOfVariables() {
        return this._variables.size();
    }

    public String toString() {
        return this.toString(0, Math.min(10, this.sizeOfConstraints()), 0, Math.min(10, this.sizeOfVariables()));
    }

    public String toString(int n, int n2, int n3, int n4) {
        Object object;
        String string = System.getProperties().getProperty("line.separator");
        String string2 = "Problem: ";
        string2 = String.valueOf(string2) + "vars=" + this.sizeOfVariables();
        string2 = String.valueOf(string2) + ", consts=" + this.sizeOfConstraints();
        string2 = String.valueOf(string2) + ", coefs=" + this.sizeOfCoefficients();
        string2 = String.valueOf(string2) + string;
        string2 = String.valueOf(string2) + this._metadata;
        string2 = String.valueOf(string2) + string + "--- Constraints ---" + string;
        int n5 = n;
        while (n5 < n2) {
            Constraint constraint = (Constraint)this._constraints.elementAt(n5);
            string2 = String.valueOf(string2) + constraint + string;
            ++n5;
        }
        string2 = String.valueOf(string2) + string + "--- Variables ---" + string;
        int n6 = n3;
        while (n6 < n4) {
            object = (Variable)this._variables.elementAt(n6);
            string2 = String.valueOf(string2) + object + string;
            ++n6;
        }
        string2 = String.valueOf(string2) + string + "--- Coefficients ---" + string;
        object = this._coefficients.elements();
        while (object.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)object.nextElement();
            int n7 = matrixElementI.getRowIndex();
            int n8 = matrixElementI.getColumnIndex();
            if (n8 >= n4 || n8 < n3 || n7 >= n2 || n7 < n) continue;
            string2 = String.valueOf(string2) + "[" + n7 + "][" + n8 + "] " + matrixElementI.getValue() + string;
        }
        return string2;
    }

    public Enumeration variables() {
        return this._variables.elements();
    }
}

