/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import logging.Reporter;
import mapping.data.JobClass;

public class JobClassesStatisticsJPanel
extends JPanel {
    private static final long serialVersionUID = 5098254999901115141L;
    private static String[] headers = new String[]{"Class ID", "Number of Jobs", "Arrival Rate", "Actual Arrival Rate", "Execution Time", "Actual Execution Time", "T/O", "Waiting Time", "Waiting Time-T/O", "Communication Time", "Communication Time-T/O", "Response Time", "Response Time-T/O"};
    private MainFrame frame;
    private JTable jTable;
    private DefaultTableModel model;
    private JButton buttonUpdate = new JButton("Update");
    private JButton buttonSave = new JButton("Save");
    private String iconsFolder = "Icons";

    public JobClassesStatisticsJPanel(final MainFrame frame) {
        this.frame = frame;
        this.setLayout(new BorderLayout());
        this.model = new DefaultTableModel();
        this.jTable = new JTable(this.model);
        JScrollPane scrollPane = new JScrollPane(this.jTable);
        this.jTable.setEnabled(false);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.buttonSave);
        buttonsPanel.add(this.buttonUpdate);
        this.buttonSave.setIcon(new ImageIcon(String.valueOf(this.iconsFolder) + "/" + "filesave_22.png"));
        this.buttonUpdate.setIcon(new ImageIcon(String.valueOf(this.iconsFolder) + "/" + "reload_22.png"));
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonsPanel, "North");
        this.buttonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser fileChooser = new JFileChooser();
                    int returnedValue = fileChooser.showSaveDialog(((JButton)e.getSource()).getParent());
                    if (returnedValue != 0) {
                        return;
                    }
                    Reporter.generateReportAboutJobClasses(frame.getMapper(), frame.getGeneratorsController(), fileChooser.getSelectedFile().getAbsolutePath());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return;
                }
            }
        });
        this.buttonUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JobClassesStatisticsJPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(3);
        this.model = new DefaultTableModel(headers, this.frame.getMapper().getClassesTable().size());
        try {
            int i = 1;
            while (i <= this.frame.getMapper().getClassesTable().size()) {
                this.model.setValueAt(((JobClass)this.frame.getMapper().getClassesTable().get(i)).getIndex(), i - 1, 0);
                this.model.setValueAt(this.frame.getGeneratorsController().getGenerators()[i - 1].getJobsGeneratedNumber(), i - 1, 1);
                this.model.setValueAt(formatter.format(this.frame.getMapper().getJobClass(i).getArrivalRate()), i - 1, 2);
                this.model.setValueAt(formatter.format(this.frame.getGeneratorsController().getGenerators()[i - 1].getActualRate()), i - 1, 3);
                this.model.setValueAt(this.frame.getMapper().getJobClass(i).getexecutionTime(), i - 1, 4);
                this.model.setValueAt(formatter.format(this.frame.getGeneratorsController().getGenerators()[i - 1].getAcutualIterationAverage()), i - 1, 5);
                this.model.setValueAt(this.frame.getMapper().getJobsTable().getTimeOutedJobsCount(i), i - 1, 6);
                this.model.setValueAt(formatter.format(this.frame.getMapper().getJobsTable().getSchedulingDelayInMilliSeconds(i) / 1000.0), i - 1, 7);
                this.model.setValueAt(formatter.format(this.frame.getMapper().getJobsTable().getSchedulingDelayInMilliSecondsIncludingTimedOut(i) / 1000.0), i - 1, 8);
                this.model.setValueAt(formatter.format(this.frame.getMapper().getJobsTable().getCommunicationDelayInSeconds(i)), i - 1, 9);
                this.model.setValueAt(formatter.format(this.frame.getMapper().getJobsTable().getCommunicationDelayInSecondsIncludingTimedOut(i)), i - 1, 10);
                this.model.setValueAt(formatter.format(this.frame.getMapper().getJobsTable().getResponseTimeInSeconds(i)), i - 1, 11);
                this.model.setValueAt(formatter.format(this.frame.getMapper().getJobsTable().getResponseTimeInSecondsIncludingTimedOut(i)), i - 1, 12);
                ++i;
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            return;
        }
        this.jTable.setModel(this.model);
        this.repaint();
    }

    public void setEnabled(boolean enabled) {
        this.buttonSave.setEnabled(enabled);
        this.buttonUpdate.setEnabled(enabled);
    }
}

