/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class ProgressBarFrame
extends JFrame {
    private static final long serialVersionUID = -7757334730245490290L;
    private JProgressBar progressBar;
    private JList messagesList;
    private JScrollPane scrollPane;

    public ProgressBarFrame(String title, int max) {
        super(title);
        this.progressBar = new JProgressBar(0, max);
        this.progressBar.setValue(1);
        this.progressBar.setStringPainted(true);
        this.messagesList = new JList();
        this.messagesList.setModel(new DefaultListModel());
        JPanel progressJPanel = new JPanel();
        progressJPanel.add(this.progressBar);
        this.getContentPane().add((Component)progressJPanel, "First");
        this.scrollPane = new JScrollPane(this.messagesList);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setSize(400, 200);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    public void changeProgress(int progress, String message) {
        this.progressBar.setValue(progress);
        this.messagesList.add(new JLabel(message));
        ((DefaultListModel)this.messagesList.getModel()).addElement(message);
        this.scrollPane.getVerticalScrollBar().getModel().setValue(this.scrollPane.getVerticalScrollBar().getModel().getMaximum());
        this.progressBar.repaint();
        this.setVisible(true);
    }

    public void done() {
        Toolkit.getDefaultToolkit().beep();
        this.setCursor(null);
    }
}

