/*
 * Decompiled with CFR 0.152.
 */
package logging;

import generating.GeneratorsController;
import java.io.IOException;
import java.text.DecimalFormat;
import logging.Reporter;
import mapping.Mapper;

public class SavingRunnable
implements Runnable {
    private boolean alive = true;
    private Mapper mapper;
    private GeneratorsController controller;
    private int timeBetweenSaves;
    private Thread thisThread;
    public static final String RESULTS_FOLDER = "Results";
    DecimalFormat formatter = new DecimalFormat();

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public GeneratorsController getContoller() {
        return this.controller;
    }

    public void setContoller(GeneratorsController contoller) {
        this.controller = contoller;
    }

    public int getTimeBetweenSaves() {
        return this.timeBetweenSaves;
    }

    public void setTimeBetweenSaves(int timeBetweenSaves) {
        this.timeBetweenSaves = timeBetweenSaves;
    }

    public SavingRunnable(Mapper mapper, GeneratorsController controller, int timeBetweenSaves) {
        this.setMapper(mapper);
        this.setContoller(controller);
        this.setTimeBetweenSaves(timeBetweenSaves);
    }

    public void run() {
        this.formatter.setMaximumFractionDigits(1);
        long i = 0L;
        String filePrefix = new String();
        while (this.isAlive()) {
            block5: {
                try {
                    Thread.sleep(60000 * this.getTimeBetweenSaves());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    if (this.isAlive()) break block5;
                    return;
                }
            }
            ++i;
            filePrefix = String.valueOf(this.getMapper().getMappingScheme().getDescription()) + "_" + this.formatter.format(this.mapper.getTimeElapsedInTimeUnits()) + "_";
            Reporter.generateReportAboutSystemStatistics(this.getMapper(), "Results/" + filePrefix + "systemStats.txt");
            try {
                Reporter.generateReportAboutJobClasses(this.getMapper(), this.getContoller(), "Results/" + filePrefix + "classesStats.txt");
                Reporter.generateReportOfMue(this.getMapper(), "Results/" + filePrefix + "mue.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getMapper().getJobsTable().saveToFile("Results/" + filePrefix + "jobs.txt");
        }
    }

    public void startThread() {
        this.setAlive(true);
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        String filePrefix = String.valueOf(this.getMapper().getMappingScheme().getDescription()) + "_" + this.formatter.format(this.mapper.getTimeElapsedInTimeUnits()) + "_Final_";
        Reporter.generateReportAboutSystemStatistics(this.getMapper(), "Results/" + filePrefix + "systemStats.txt");
        try {
            Reporter.generateReportAboutJobClasses(this.getMapper(), this.getContoller(), "Results/" + filePrefix + "classesStats.txt");
            Reporter.generateReportOfMue(this.getMapper(), "Results/" + filePrefix + "mue.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getMapper().getJobsTable().saveToFile("Results/" + filePrefix + "jobs.txt");
    }
}

