/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import mapping.FCFS_MS;
import mapping.data.IDsQueue;
import mapping.data.Server;

public class FCFS_MS_Thread
implements Runnable {
    private boolean alive = true;
    private Thread thisThread;
    private FCFS_MS fcfs_ms;

    public FCFS_MS_Thread(FCFS_MS fcfs_ms) {
        this.setAlive(true);
        this.fcfs_ms = fcfs_ms;
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void startThread() {
        System.out.println("LPAS Thread started");
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public void run() {
        Server server = null;
        IDsQueue<Integer> q = this.fcfs_ms.getMapper().getAvailableServersQueue();
        while (this.isAlive()) {
            if (!q.isEmpty()) {
                int result;
                int serverID = q.peak();
                server = (Server)this.fcfs_ms.getMapper().getServersTable().get(serverID);
                if (server.getNumberOfActiveJobs() != 0 || this.fcfs_ms.getMapper().getServersTable().isServerDown(serverID) || (result = this.fcfs_ms.sendJobForServer(serverID)) >= 0) continue;
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    if (this.isAlive()) continue;
                    return;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

