/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import mapping.Gcu_MS;
import mapping.data.IDsQueue;
import mapping.data.Job;
import mapping.data.Server;

public class Gcu_MS_Thread
implements Runnable {
    private boolean alive = true;
    private Thread thisThread;
    Gcu_MS gcu_ms;

    public Gcu_MS_Thread(Gcu_MS gcu_ms) {
        this.setAlive(true);
        this.setGcu_ms(gcu_ms);
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public Gcu_MS getGcu_ms() {
        return this.gcu_ms;
    }

    public void setGcu_ms(Gcu_MS gcu_ms) {
        this.gcu_ms = gcu_ms;
    }

    public void startThread() {
        System.out.println("LPAS Thread started");
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public void run() {
        Server server = null;
        IDsQueue<Integer> q = this.getGcu_ms().getMapper().getAvailableServersQueue();
        while (this.isAlive()) {
            if (!q.isEmpty()) {
                Job obj;
                int serverID = q.peak();
                server = (Server)this.getGcu_ms().getMapper().getServersTable().get(serverID);
                if (server.getNumberOfActiveJobs() != 0 || this.getGcu_ms().getMapper().getServersTable().isServerDown(serverID) || (obj = this.getGcu_ms().sendJobForServer(serverID)) != null) continue;
                try {
                    Thread.sleep(30L);
                    continue;
                }
                catch (InterruptedException e) {
                    if (this.isAlive()) continue;
                    return;
                }
            }
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

