/*
 * Decompiled with CFR 0.152.
 */
package pulling.availability_predection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import pulling.availability_predection.TimeStamp;
import pulling.availability_predection.WeekDay;

public class AvailabilityLogger {
    static final int TIMESLOT_LENGTH = 15;
    static final double NOT_CALCULATED_YET = -1.0;
    static final String HISTORY_FILE_NAME = "availbility.his";
    private int timeresolution = 10;
    private int pastReadingsCount = 4;

    public AvailabilityLogger() {
        this.initHistoryFile();
    }

    public AvailabilityLogger(int timeResolution, int pastReadingsCount) {
        this.setTimeresolution(timeResolution);
        this.setPastReadingsCount(pastReadingsCount);
        this.initHistoryFile();
    }

    public int getPastReadingsCount() {
        return this.pastReadingsCount;
    }

    private void setPastReadingsCount(int pastReadingsCount) {
        this.pastReadingsCount = pastReadingsCount;
    }

    private int getRecordLength() {
        return 30 + this.getPastReadingsCount() * 8;
    }

    public int getTimeresolution() {
        return this.timeresolution;
    }

    protected void setTimeresolution(int timeresolution) {
        this.timeresolution = timeresolution;
    }

    public void initHistoryFile() {
        TimeStamp timeStamp = new TimeStamp();
        try {
            RandomAccessFile file = new RandomAccessFile(HISTORY_FILE_NAME, "rw");
            int i = 0;
            while (i < WeekDay.values().length) {
                timeStamp = new TimeStamp();
                int j = 0;
                while ((double)j < 1440.0 / (double)this.getTimeresolution()) {
                    this.writeFixedLengthString((Object)((Object)WeekDay.values()[i]) + "_" + timeStamp.toString(), 15, file);
                    int k = 0;
                    while (k < this.getPastReadingsCount()) {
                        file.writeDouble(-1.0);
                        ++k;
                    }
                    timeStamp.addMinutes(this.getTimeresolution());
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void initHistoryFileWithRandomData() {
        TimeStamp timeStamp = new TimeStamp();
        try {
            RandomAccessFile file = new RandomAccessFile(HISTORY_FILE_NAME, "rw");
            int i = 0;
            while (i < WeekDay.values().length) {
                timeStamp = new TimeStamp();
                int j = 0;
                while ((double)j < 1440.0 / (double)this.getTimeresolution()) {
                    this.writeFixedLengthString((Object)((Object)WeekDay.values()[i]) + "_" + timeStamp.toString(), 15, file);
                    int k = 0;
                    while (k < this.getPastReadingsCount()) {
                        file.writeDouble(Math.random());
                        ++k;
                    }
                    timeStamp.addMinutes(this.getTimeresolution());
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void printHistoryFile(int fractionsDigits) {
        if (fractionsDigits <= 1) {
            fractionsDigits = 2;
        }
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(fractionsDigits);
        try {
            RandomAccessFile file = new RandomAccessFile(HISTORY_FILE_NAME, "r");
            int i = 0;
            while (i < WeekDay.values().length) {
                int j = 0;
                while ((double)j < 1440.0 / (double)this.getTimeresolution()) {
                    System.out.print(String.valueOf(this.readFixedLengthString(15, file)) + ": ");
                    int k = 0;
                    while (k < this.getPastReadingsCount()) {
                        System.out.print(String.valueOf(formatter.format(file.readDouble())) + "\t");
                        ++k;
                    }
                    System.out.print("j: " + (j + 1) + " \n");
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setReadingQuick(double reading, int ageRank, WeekDay wd, TimeStamp ts) throws IOException {
        RandomAccessFile file = new RandomAccessFile(HISTORY_FILE_NAME, "rw");
        file.seek((long)(wd.ordinal() * (1440 / this.getTimeresolution()) * this.getRecordLength() + ts.howManyPeriodsBefore(this.getTimeresolution()) * this.getRecordLength() + 30) + 8L * (long)ageRank);
        file.writeDouble(reading);
        file.close();
    }

    public static void main(String[] args) throws IOException {
        AvailabilityLogger logger = new AvailabilityLogger();
        logger.setTimeresolution(7);
        logger.printHistoryFile(2);
    }

    public void insertNewReading(double reading, WeekDay wd, TimeStamp ts) throws IOException {
        RandomAccessFile file = new RandomAccessFile(HISTORY_FILE_NAME, "rw");
        int recordsInPreviousWeekDays = (int)((double)wd.ordinal() * Math.ceil(1440.0 / (double)this.getTimeresolution()));
        file.seek(recordsInPreviousWeekDays * this.getRecordLength() + this.howManyPeriods(ts) * this.getRecordLength() + 30);
        double[] oldReading = new double[this.getPastReadingsCount()];
        int i = 0;
        while (i < this.getPastReadingsCount()) {
            oldReading[i] = file.readDouble();
            ++i;
        }
        file.seek(recordsInPreviousWeekDays * this.getRecordLength() + this.howManyPeriods(ts) * this.getRecordLength() + 30);
        file.writeDouble(reading);
        i = 0;
        while (i < this.getPastReadingsCount() - 1) {
            file.writeDouble(oldReading[i]);
            ++i;
        }
        file.close();
    }

    public double getReading(int ageRank, WeekDay wd, TimeStamp ts) {
        double reading = 0.0;
        try {
            RandomAccessFile file = new RandomAccessFile(HISTORY_FILE_NAME, "rw");
            int recordsInPreviousWeekDays = (int)((double)wd.ordinal() * Math.ceil(1440.0 / (double)this.getTimeresolution()));
            file.seek((long)(recordsInPreviousWeekDays * this.getRecordLength() + this.howManyPeriods(ts) * this.getRecordLength() + 30) + 8L * (long)(ageRank - 1));
            reading = file.readDouble();
            if (file != null) {
                file.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return reading;
    }

    public String readFixedLengthString(int n, DataInput inStream) throws IOException {
        char[] chars = new char[n];
        int i = 0;
        while (i < n) {
            chars[i] = inStream.readChar();
            ++i;
        }
        return new String(chars);
    }

    public void writeFixedLengthString(String toBeWritten, int n, DataOutput outStream) throws IOException {
        char[] chars = new char[n];
        toBeWritten.getChars(0, toBeWritten.length(), chars, 0);
        int i = Math.min(toBeWritten.length(), n);
        while (i < n) {
            chars[i] = 32;
            ++i;
        }
        outStream.writeChars(new String(chars));
    }

    private int howManyPeriods(TimeStamp ts) {
        return (ts.getHour() * 60 + ts.getMinute()) / this.getTimeresolution();
    }
}

