/*
 * Decompiled with CFR 0.152.
 */
package pulling.executing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import logging.Logger;
import pulling.executing.CompletionAnnouncer_Xgrid;
import pulling.executing.ServerSideExecuter;

public class ServerSideExecuter_Xgrid
extends ServerSideExecuter {
    private static final long serialVersionUID = -5437657674181729974L;
    final String PERCENT_DONE = "percentDone";
    final String DATE_STARTED = "dateStarted";
    final String DATE_SUBMITTED = "dateSubmitted";
    final String DATE_STOPPED = "dateStopped";
    final String JOB_STATUS = "jobStatus";
    final String ACTIVE_CPU_POWER = "activeCPUPower";
    final String DIRECTORY = "/Users/Shared/Working/";
    String mapperHostName;
    String password;
    private CompletionAnnouncer_Xgrid completionAnnouncer;

    public ServerSideExecuter_Xgrid(String mapperHostName, String password) {
        this.mapperHostName = mapperHostName;
        this.password = password.trim();
    }

    public void startExecuter() {
        this.completionAnnouncer = new CompletionAnnouncer_Xgrid(this.mapperHostName, this.password, this);
        this.completionAnnouncer.startThread();
    }

    public void stopExecuter() {
        this.completionAnnouncer.stopThread();
    }

    public long submitLoopJob(String hostName, String password, String workingDirectory, long iter, double ratio) {
        Logger logger = new Logger("xgrid");
        String runnable = "/usr/bin/java -jar LoopEnhancedARGH.jar";
        String command = "xgrid -h " + hostName + " -p \"" + password + "\"" + " -job submit -in " + workingDirectory + " " + runnable + " " + iter + " " + ratio;
        logger.log(command);
        logger.closeStreams();
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(command);
            InputStream inputstream = proc.getInputStream();
            InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
            BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
            String line = bufferedreader.readLine();
            if (line != null) {
                return Long.parseLong(this.getValueAfterEqual(line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public double getPercentageDone(long id, String hostname, String password) {
        String command = "xgrid -h " + hostname + " -p \"" + password + "\" -job attributes -id " + id;
        Runtime runtime = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = runtime.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStream inputstream = proc.getInputStream();
        InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        try {
            String line;
            while ((line = bufferedreader.readLine()) != null) {
                if (!this.getKeyBeforeEqual(line).matches("percentDone")) continue;
                return Double.parseDouble(this.getValueAfterEqual(line));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1.0;
    }

    public double getDateSubmitted(long id, String hostname, String password) {
        String command = "xgrid -h " + hostname + " -p \"" + password + "\" -job attributes -id " + id;
        Runtime runtime = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = runtime.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStream inputstream = proc.getInputStream();
        InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        try {
            String line;
            while ((line = bufferedreader.readLine()) != null) {
                if (!this.getKeyBeforeEqual(line).matches("dateSubmitted")) continue;
                return Double.parseDouble(this.getValueAfterEqual(line));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1.0;
    }

    public String getDateStarted(long id, String hostname, String password) {
        String command = "xgrid -h " + hostname + " -p \"" + password + "\" -job attributes -id " + id;
        Runtime runtime = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = runtime.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStream inputstream = proc.getInputStream();
        InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        try {
            String line;
            while ((line = bufferedreader.readLine()) != null) {
                if (!this.getKeyBeforeEqual(line).matches("dateStarted")) continue;
                return this.getValueAfterEqual(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getDateStopped(long id, String hostname, String password) {
        String command = "xgrid -h " + hostname + " -p \"" + password + "\" -job attributes -id " + id;
        Runtime runtime = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = runtime.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStream inputstream = proc.getInputStream();
        InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        try {
            String line;
            while ((line = bufferedreader.readLine()) != null) {
                if (!this.getKeyBeforeEqual(line).matches("dateStopped")) continue;
                return this.getValueAfterEqual(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getJobStatus(long id, String hostname, String password) {
        String command = "xgrid -h " + hostname + " -p \"" + password + "\" -job attributes -id " + id;
        Runtime runtime = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = runtime.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStream inputstream = proc.getInputStream();
        InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        try {
            String line;
            while ((line = bufferedreader.readLine()) != null) {
                if (!this.getKeyBeforeEqual(line).matches("jobStatus")) continue;
                return this.getValueAfterEqual(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public double getActiveCPU(long id, String hostname, String password) {
        String command = "xgrid -h " + hostname + " -p \"" + password + "\" -job attributes -id " + id;
        Runtime runtime = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = runtime.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStream inputstream = proc.getInputStream();
        InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        try {
            String line;
            while ((line = bufferedreader.readLine()) != null) {
                if (!this.getKeyBeforeEqual(line).matches("activeCPUPower")) continue;
                return Double.parseDouble(this.getValueAfterEqual(line));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1.0;
    }

    public long stopJob(long id, String hostname, String password) {
        String command = "xgrid -h " + hostname + " -p \"" + password + "\"" + " -job stop -id " + id;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(command);
            proc.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public long deleteJob(long id, String hostname, String password) {
        String command = "xgrid -h " + hostname + " -p \"" + password + "\"" + " -job delete -id " + id;
        System.out.println("XgridLayerInterface.submit: " + command);
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(command);
            proc.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public String getKeyBeforeEqual(String input) {
        int i = 0;
        i = 0;
        while (i < input.length()) {
            if (input.charAt(i) == '=') {
                return input.substring(0, i).trim();
            }
            ++i;
        }
        return "";
    }

    public String getValueAfterEqual(String input) {
        int i = 0;
        i = 0;
        while (i < input.length()) {
            if (input.charAt(i) == '=') break;
            ++i;
        }
        int j = i;
        while (j < input.length() && input.charAt(j) != ';') {
            ++j;
        }
        if (j >= input.length()) {
            --j;
        }
        return input.substring(i + 1, j).trim();
    }
}

