/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.tsp;

import drasys.or.graph.GraphI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.TSPBase;
import drasys.or.graph.tsp.TSPError;
import drasys.or.graph.tsp.TourNotFoundException;

public abstract class ConstructBase
extends TSPBase {
    Vert _head;
    Vert _tail;
    Vert _free;

    public ConstructBase() {
    }

    public ConstructBase(GraphI graphI) {
        super(graphI);
    }

    protected abstract void construct() throws TourNotFoundException;

    public double constructClosedTour() throws TourNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        this._closed = true;
        this.initVertices(-1, -1);
        this.initTour(0, 0);
        this.construct();
        return this.getCost();
    }

    public double constructOpenTour() throws TourNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        this._closed = false;
        this.initVertices(-1, -1);
        this.initTour(-1, -1);
        this.construct();
        return this.getCost();
    }

    public double constructOpenTour(Object object, Object object2) throws TourNotFoundException, VertexNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        if (object.equals(object2)) {
            throw new TSPError("The origin and destination keys are equal, use 'constructClosedTour' instead.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException("The origin vertex does not exist");
        }
        VertexI vertexI2 = this._graph.getVertex(object2);
        if (vertexI2 == null) {
            throw new VertexNotFoundException("The destination vertex does not exist");
        }
        this._closed = vertexI == vertexI2;
        this.initVertices(vertexI.getIndex(), vertexI2.getIndex());
        this.initTour(this._fromSelectedIdx, this._toSelectedIdx);
        this.construct();
        return this.getCost();
    }

    public double constructOpenTourFrom(Object object) throws TourNotFoundException, VertexNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException("The origin vertex does not exist");
        }
        this._closed = false;
        this.initVertices(vertexI.getIndex(), -1);
        this.initTour(this._fromSelectedIdx, -1);
        this.construct();
        return this.getCost();
    }

    public double constructOpenTourTo(Object object) throws TourNotFoundException, VertexNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException("The destination vertex does not exist");
        }
        this._closed = false;
        this.initVertices(-1, vertexI.getIndex());
        this.initTour(-1, this._toSelectedIdx);
        this.construct();
        return this.getCost();
    }

    private void initTour(int n, int n2) throws TourNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        if (this._size < 2) {
            throw new TSPError("The graph must have at least two vertices");
        }
        int n3 = this._size;
        this._closed = n != -1 && n == n2;
        this._head = new Vert(n);
        this._head._next = this._tail = new Vert(n2);
        this._free = null;
        int n4 = 0;
        while (n4 < n3) {
            if (n4 != n && n4 != n2) {
                Vert vert = new Vert(n4);
                vert._nextFree = this._free;
                this._free = vert;
            }
            ++n4;
        }
    }

    protected void saveTour() {
        int n = this._size;
        this._bestCost = 0.0;
        this._bestTour = new int[n];
        Vert vert = this._head._idx == -1 ? this._head._next : this._head;
        int n2 = 0;
        while (n2 < n) {
            this._bestTour[n2] = vert._idx;
            if (vert._next != null) {
                this._bestCost += this.forwardCost(vert._idx, vert._next._idx);
            }
            ++n2;
            vert = vert._next;
        }
    }

    public void selectVertex(Object object, boolean bl) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph is not set.");
        }
        this.checkChangeCount();
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException();
        }
        this._selected[vertexI.getIndex()] = bl;
    }

    public void selectVertex(boolean bl) {
        if (this._graph == null) {
            throw new TSPError("The graph is not set.");
        }
        this.checkChangeCount();
        int n = 0;
        while (n < this._selected.length) {
            this._selected[n] = bl;
            ++n;
        }
    }

    public void selectVertex(boolean[] blArray) {
        if (this._graph == null) {
            throw new TSPError("The graph is not set.");
        }
        this.checkChangeCount();
        if (blArray.length != this._graph.sizeOfVertices()) {
            throw new TSPError("The size of the select array  must equal the number of vertices in the graph.");
        }
        int n = 0;
        while (n < this._selected.length) {
            this._selected[n] = blArray[n];
            ++n;
        }
    }

    class Vert {
        int _idx;
        Vert _next;
        Vert _nextFree;

        Vert(int n) {
            this._idx = n;
            this._next = null;
            this._nextFree = null;
        }
    }
}

