/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat.model;

import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorI;
import drasys.or.stat.model.GeneralLinearModelI;
import drasys.or.stat.model.LinearRegression;
import drasys.or.stat.model.LinearRegressionI;
import drasys.or.util.Array;

public class ReverseLinear
extends LinearRegression
implements LinearRegressionI {
    int _histCnt = 0;
    int[][] _histVars;
    VectorI[] _histPvals;

    public ReverseLinear(VectorI vectorI, MatrixI matrixI) {
        super(vectorI, matrixI);
    }

    public ReverseLinear(GeneralLinearModelI generalLinearModelI) {
        super(generalLinearModelI);
    }

    private void hist(VectorI vectorI) {
        if (this._histCnt < this._histVars.length) {
            this._histVars[this._histCnt] = this._selectedVariables;
            this._histPvals[this._histCnt] = vectorI;
            ++this._histCnt;
        }
    }

    public int solve() {
        this._histCnt = 0;
        this._histVars = new int[this._selectedVariables.length][];
        this._histPvals = new VectorI[this._selectedVariables.length];
        boolean[] blArray = new boolean[this._n];
        int n = 0;
        while (n < this._requiredVariables.length) {
            blArray[this._requiredVariables[n]] = true;
            ++n;
        }
        this.setSelectedVariables(Array.union(this._enteringVariables, this._requiredVariables));
        VectorI vectorI = this.getTPV();
        this.hist(vectorI);
        while (true) {
            int n2 = -1;
            double d = -1.0;
            int n3 = this._selectedVariables.length;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this._selectedVariables[n4];
                double d2 = vectorI.elementAt(n4);
                if (d2 > this._exitPValue && !blArray[n5] && (n2 == -1 || d2 > d)) {
                    n2 = n4;
                    d = d2;
                }
                ++n4;
            }
            if (n2 == -1) {
                return n3;
            }
            int[] nArray = new int[n3 - 1];
            int n6 = 0;
            while (n6 < n2) {
                nArray[n6] = this._selectedVariables[n6];
                ++n6;
            }
            int n7 = n2 + 1;
            while (n7 < n3) {
                nArray[n7 - 1] = this._selectedVariables[n7];
                ++n7;
            }
            this.setSelectedVariables(nArray);
            vectorI = this.getTPV();
            this.hist(vectorI);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n");
        stringBuffer.append("---------------------------\n");
        stringBuffer.append("---- Reverse Algorithm ----\n");
        stringBuffer.append("---------------------------\n");
        stringBuffer.append("\n");
        int n = 0;
        while (n < this._histCnt) {
            stringBuffer.append("ITERATION-" + n + "\n");
            int[] nArray = this._histVars[n];
            VectorI vectorI = this._histPvals[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                stringBuffer.append("  (" + nArray[n2] + ") = " + vectorI.elementAt(n2) + "\n");
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

