package arrival_generator;

import mapping.Mapper;
import mapping.data.JobClass;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

/**
* This class allows a user to read the arrival times and executionTime from a file,
* as opposed to having them generated using a probability distribution
*
* @author Ben Kybartas
*
*/
public class FILE_READ_AG extends ArrivalGenerator{
	private Mapper mapper;
	
	private JobClass jobclass;
	
	private String filename;
	
	private long ArrivalTime;
	
	private long executionTime;
	
	private BufferedReader file;
	
	public FILE_READ_AG(JobClass jobClass, Mapper mapper, String filename)
	{
		
		this.setMapper(mapper);
		this.setDescription("FILE_READ_AG");
		this.setJobClass(jobClass);
		this.setFilename(filename);
		this.setArrivalTime(0);
		this.setexecutionTime(0);
		try 
		{
			this.setBufferedReader(new BufferedReader(new FileReader(this.getFilename())));
		} 
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}
	
	protected void setBufferedReader(BufferedReader bufferedReader)
	{
		file = bufferedReader;
	}
	
	protected BufferedReader getBufferedReader()
	{
		return file;
	}
	protected String getFilename()
	{
		return this.filename;
	}
	
	protected void setFilename(String fileName)
	{
		this.filename = fileName;
	}
	
	protected long getArrivalTime()
	{
		return this.ArrivalTime;
	}
	
	protected void setArrivalTime(long ArrivalTime)
	{
		this.ArrivalTime = ArrivalTime;
	}
	
	protected long getexecutionTime()
	{
		return this.executionTime;
	}
	
	protected void setexecutionTime(long executionTime)
	{
		this.executionTime = executionTime;
	}
	
	protected Mapper getMapper()
	{
		return this.mapper;
	}
	
	protected void setMapper(Mapper mapper)
	{
		this.mapper = mapper;
	}
	
	protected JobClass getJobClass()
	{
		return this.jobclass;
	}
	
	protected void setJobClass(JobClass jobClass)
	{
		this.jobclass = jobClass;
	}
	
	/**
	 * This class iterates through the file line by line and sets the appropriate values for arrival times
	 * and execution times
	 * 
	 * @throws IOException
	 */
	public void findInfo() throws IOException
	{
		String currentLine;
		
		int endofJc, endofArriv;
		String exec, arriv;
		try
		{
			if ((currentLine = file.readLine()) != null)
			{
				endofJc = 0;
				endofArriv = 0;
				
				while (currentLine.charAt(endofJc++) != ';'){}
				endofArriv = endofJc + 1;
				
				while (currentLine.charAt(endofArriv++) != ';'){}
				arriv = currentLine.substring(endofJc, endofArriv - 1).trim();
				this.setArrivalTime(Long.parseLong(arriv));
					
				exec = currentLine.substring(endofArriv).trim();
				this.setexecutionTime(Long.parseLong(exec));

			}
			else
			{
				//If the end of the file is reached, then the same file will be reloaded and reread
				this.setBufferedReader(new BufferedReader(new FileReader(this.getFilename())));
			}
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}
	
	public long[] getNextJobInfo()
	{
		long[] JobInfo = new long[3];
		long JobClass;
		
		JobClass = (long) this.getJobClass().getIndex();
		
		try
		{
			findInfo();		
		}
		catch(IOException e)
		{
		e.printStackTrace();
		}
		JobClass = (long) this.getJobClass().getIndex();

		JobInfo[0] = JobClass;
		JobInfo[1] = this.getArrivalTime();
		JobInfo[2] = this.getexecutionTime();
				
		return JobInfo;
	}

	@Override
	public void closeLogger() 
	{
		// The logger is not used here since it instead uses the job logs as job generators		
	}
}