package executing;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

import mapping.Mapper;

/**
 * This is the built in executer which submits the job information to the puller
 * which then executes the job
 * 
 * @author Majd Kokaly and Ben Kybartas
 *
 */
public class MapperSideExecuter_BuiltIn extends MapperSideExecuter {
	
	/**
	 * The serialVersionUID is used to universally identify this version of this class. 
	 */
	private static final long serialVersionUID = 3582088914870407661L;

	private int serverPort = 37935;

	public int getServerPort() {
		return serverPort;
	}

	public void setServerPort(int serverPort) {
		this.serverPort = serverPort;
	}

	public MapperSideExecuter_BuiltIn() {

	}

	Socket serverSocket = null;
	DataOutputStream out = null;

	public long submitLoopJob(String hostName, int serverID, long jobID,
			long executionTime, double ratio) 
	{
		try 
		{
			serverSocket = new Socket(hostName, this.getServerPort());
			out = new DataOutputStream(serverSocket.getOutputStream());
			/* ---------------------Format of message sent is ---------------------------*/ 
			/*                 executionTime#ratio#serverID#mapperJobID                     */
			/* --------------------------------------------------------------------------*/
			
			System.out.print( "submitLoop: " + executionTime + "#" + ratio + "#" + serverID + "#" + jobID);
			out.writeBytes(executionTime + "#" + ratio + "#" + serverID + "#" + jobID);
			out.flush();
			return 1;
		} 
		catch (IOException ex) 
		{
			ex.printStackTrace();
			return Mapper.JOB_FAILED;
		} 
		finally 
		{
			if (out != null)
				try 
				{
					out.close();
				} 
				catch (IOException e) 
				{
					e.printStackTrace();
				}
			if (serverSocket != null)
				try 
				{
					serverSocket.close();
				} 
				catch (IOException e) 
				{
					e.printStackTrace();
				}
		}
	}

	public static void main(String[] args) {
	}

	@Override
	public long deleteJob(long id, String hostname) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String getDateStarted(long id, String hostname) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getDateStopped(long id, String hostname) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getJobStatus(long id, String hostname) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public double getPercentageDone(long id, String hostname) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void startExecuter() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public long stopJob(long id, String hostname) {
		// TODO Auto-generated method stub
		return 0;
	}

}
