package generating;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

/**
 * This is a class which can be used to create a file of all the jobs generated. 
 * This can later be used with FILE_READ_AG class to repeat the same jobs in a later test.
 * 
 * @author Ben Kybartas
 *
 */
public class JobLogger {

	private String filename;
	private int JobClass;
	
	private FileWriter filewriter;
	private BufferedWriter bufferedwriter;
	
	final private String REPORTS_FOLDER = new String("Reports");
		
	/**
	 * Each job class will have its own file containing all the jobs for that individual
	 * class
	 * 
	 * @param Filename
	 * @param Jobclass
	 */
	public JobLogger(String Filename, int Jobclass)
	{
			this.setFilename(Filename);
			this.setJobClass(Jobclass);
			try 
			{
				this.setFileWriter(new FileWriter(REPORTS_FOLDER + "/" + this.getFilename() + ".jc", false));
				this.setBufferedWriter(new BufferedWriter(this.getFileWriter()));
			} 
			catch (IOException e) 
			{
				e.printStackTrace();
			}
	}
	
	/**
	 * Tell the job logger to log a specific job
	 * 
	 * @param ArrivalTime The arrival time of the job
	 * @param ExecutionTime the execution time of the job
	 */
	public void logJob(long ArrivalTime, long ExecutionTime)
	{
		String jobinfo;
		jobinfo = this.getJobClass() + ";" + ArrivalTime + ";" + ExecutionTime;
		
		try 
		{
			this.getBufferedWriter().append(jobinfo + "\n");
			this.getBufferedWriter().flush();
		} 
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}
	
	private void setJobClass(int jobClass)
	{
		this.JobClass = jobClass;
	}
	
	private int getJobClass()
	{
		return JobClass;
	}
	
	private void setFilename(String fileName)	
	{
		this.filename = fileName;
	}
		
	private String getFilename()
	{
		return filename;
	}
	
	private void setFileWriter(FileWriter fileWriter)
	{
		this.filewriter = fileWriter;
	}
	
	private FileWriter getFileWriter()
	{
		return filewriter;
	}
	
	private void setBufferedWriter(BufferedWriter bufferedWriter)
	{
		this.bufferedwriter = bufferedWriter;
	}
	
	private BufferedWriter getBufferedWriter()
	{
		return bufferedwriter;
	}
	
	public void closeStreams()
	{
		try 
		{
			this.getFileWriter().close();
			this.getBufferedWriter().close();
		} 
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}
}
