

package interfacing;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


//import javax.print.DocFlavor.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import javax.swing.JTable;


import mapping.LP_Solver;

/**
 * This JPanel is an interface to LP Solver.
 * It solves the LP allocation of the current Mapper object
 * @author Majd Kokaly
 */
public class LP_JPanel extends JPanel  {
	/**
	 * The serialVersionUID is used to universally identify this version of this
	 * class.
	 */
	private static final long serialVersionUID = -6939332491088413670L;
	
	/**
	 * This is main frame containing all the GUI components. A reference is needed to be
	 * able to access the Mapper object and its data.
	 */
	private MainFrame frame;
	
	/**
	 * The JTable object that views the result matrix in tabular format 
	 */
	private JTable deltaStarMatrixJTable;
	
	/**
	 * The JScrollPane object containing the JTable
	 */
	private JScrollPane deltaStarMatrixScrollPane;
	
	/**
	 * Label for lambda*
	 */
	private JLabel lambdaJLabel;
	
	/**
	 * Label for row *
	 */
	private JLabel rowJLabel;
	
	/**
	 * Label to show whether this can be stabilized
	 */
	private JLabel stabilizableJLabel;
	
	/**
	 * The JButton that resolves the LP.
	 */
	private JButton buttonUpdate;

	private JPanel northPanel;

	/**
	 * The name of the folder containing all the icons
	 */
	final String iconsFolder = "Icons";
	
	/**
	 * The default constructor. It initializes and lays the GUI objects.
	 * 
	 * @param frame
	 *            this is the MainFrame object that contains this JPanel
	 */
	public LP_JPanel(final MainFrame frame) {
		this.frame = frame;

		this.setLayout(new BorderLayout());
		deltaStarMatrixJTable = new JTable();
		deltaStarMatrixScrollPane = new JScrollPane();
		northPanel = new JPanel();
		buttonUpdate = new JButton("Solve");
		lambdaJLabel = new JLabel();
		stabilizableJLabel = new JLabel();
		rowJLabel = new JLabel();
		this.buttonUpdate.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				refresh();
			}
		});
		
	
		northPanel.setLayout(new GridLayout(2,1));
		northPanel.add(buttonUpdate);
		JPanel resultsPanel = new JPanel();
		
		lambdaJLabel.setBorder(BorderFactory.createEtchedBorder());
		rowJLabel.setBorder(BorderFactory.createEtchedBorder());
		stabilizableJLabel.setBorder(BorderFactory.createEtchedBorder());
		
		resultsPanel.add(lambdaJLabel);
		resultsPanel.add(rowJLabel);
		resultsPanel.add(stabilizableJLabel);
		northPanel.add(resultsPanel);
		this.buttonUpdate.setIcon(new ImageIcon(iconsFolder + "/" + "solve_22.png"));

		this.add(northPanel, BorderLayout.PAGE_START);
		this.add(deltaStarMatrixScrollPane, BorderLayout.CENTER);
	
	}

	public void repaint() {
		super.repaint();
	}

	Dimension d;
	
	/**
	 * This method resolves the LP and updates the JTable accordingly. 
	 */
	public void refresh() {
		double[][] deltaMatrix = null;
		Object[] results = null;
		try {
			results = LP_Solver.solveWithAjAndReturnFullDeltaStar(frame.getMapper().getServersTable(),  frame.getMapper().getClassesTable());
			deltaMatrix = (double[][]) results[0];
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	
		
		deltaStarMatrixJTable.setModel(new NonEditableTableModel(deltaMatrix.length, deltaMatrix[0].length));
		for (int i = 0; i < deltaMatrix.length; i++) {
			for (int j = 0; j < deltaMatrix[i].length; j++) {
				this.deltaStarMatrixJTable.setValueAt(deltaMatrix[i][j], i, j);
			}
		}
		
		
		
		for (int j = 0; j <  deltaMatrix[0].length; j++) {
			deltaStarMatrixJTable.getColumnModel().getColumn(j).setHeaderValue((j+1)+"");
		}
		
		
		this.lambdaJLabel.setText("\u03bb * : " +  (( Double) results[1]).doubleValue());
		this.rowJLabel.setText("\u03c1* is " +  1/(( Double) results[1]).doubleValue());
		if ( (( Double) results[1]).doubleValue() > 1)
			this.stabilizableJLabel.setText("Stabilizable");
		else 
			this.stabilizableJLabel.setText("Not Stabilizable");
		deltaStarMatrixScrollPane.setViewportView(deltaStarMatrixJTable);
	}
	
	

	
	
	
	

}
