package interfacing;

import javax.swing.table.DefaultTableModel;

/**
 * It is a DefaultTableModel class that is modified to prevent editing.
 * 
 * @author Majd Kokaly
 * 
 */
public class NonEditableTableModel extends DefaultTableModel {

	private static final long serialVersionUID = 1L;

	public NonEditableTableModel(int rows, int cols) {
		super(rows, cols);
	}

	public NonEditableTableModel(String[] cols, int rows) {
		super(cols, rows);
	}

	/**
	 * To prevent editing the id column.
	 */
	public boolean isCellEditable(int row, int column) {
		return false;
	}

}
