package interfacing;

import java.awt.BorderLayout;
import java.awt.Dimension;

import java.awt.Toolkit;
import javax.swing.*;

/**
 * This class is a JFrame that is used as progress viewer. It is used to show
 * the progress of lengthy operations. It is constructed from a progress bar
 * that views the percentage remaining from a job and message list where
 * messages appear.
 * 
 * @author Majd Kokaly
 * 
 */
public class ProgressBarFrame extends JFrame {
	/**
	 * The serialVersionUID is used to universally identify this version of this
	 * class.
	 */
	private static final long serialVersionUID = -7757334730245490290L;

	/**
	 * The progress bar that views the progress
	 */
	private JProgressBar progressBar;

	/**
	 * A JList view the list of messages
	 */
	private JList messagesList;

	/**
	 * The JScrollPane of the JList messagesList
	 */
	private JScrollPane scrollPane;

	/**
	 * The default constructor.
	 * 
	 * @param title
	 *            is the title of this JFrame
	 * @param max
	 *            is maximum value for the progress bar (usually 100)
	 */
	public ProgressBarFrame(String title, int max) {
		super(title);

		progressBar = new JProgressBar(0, max);
		progressBar.setValue(1);
		progressBar.setStringPainted(true);

		messagesList = new JList();
		messagesList.setModel(new DefaultListModel());
		JPanel progressJPanel = new JPanel();
		progressJPanel.add(progressBar);

		this.getContentPane().add(progressJPanel, BorderLayout.PAGE_START);
		scrollPane = new JScrollPane(messagesList);
		this.getContentPane().add(scrollPane, BorderLayout.CENTER);
		this.setSize(400, 200);

		// Centering the frame
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		this.setLocation(screenSize.width / 2 - this.getWidth() / 2,
				screenSize.height / 2 - this.getHeight() / 2);

		this.setVisible(true);
	}

	/**
	 * This method changes the Progress bar and adds a new message to the
	 * messages list.
	 * 
	 * @param progress
	 *            the progressBar is set to this value
	 * @param message
	 *            this message is added to the messages list
	 */
	public void changeProgress(int progress, String message) {
		progressBar.setValue(progress);
		messagesList.add(new JLabel(message));

		((DefaultListModel) messagesList.getModel()).addElement(message);
		scrollPane.getVerticalScrollBar().getModel().setValue(
				scrollPane.getVerticalScrollBar().getModel().getMaximum());
		progressBar.repaint();

		this.setVisible(true);

	}
	
	/**
	 * This method is invoked to declare that a task is done.
	 */
	public void done() {
		Toolkit.getDefaultToolkit().beep();
		setCursor(null); 
	}

}
