package interfacing;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;


/**
 * An object from this class with a ServersTableJPanel object are the
 * view/controller of the ServersTable object.
 * 
 * @author Majd Kokaly
 * 
 */
public class ServersTableModelListener implements TableModelListener {
	MainFrame frame;

	public ServersTableModelListener(MainFrame frame) {
		this.frame = frame;
	}



	/**
	 * This is invoked by the JTable object after the user modifies an entry. The
	 * ServerTable is changed accordingly.
	 */
	public void tableChanged(TableModelEvent e) {
		OurDefaultTableModel model = (OurDefaultTableModel) e.getSource();
		if (e.getColumn() == 1) { // HostName
			String hostName = null;
			hostName = ((String) model.getValueAt(e.getFirstRow(), e.getColumn())).trim();
			frame.getMapper().getServersTable().get(e.getFirstRow() + 1).setHostName(hostName);
		}		
	}
}
