package logging;

import java.io.IOException;
import java.text.DecimalFormat;

import generating.GeneratorsController;
import mapping.Mapper;

/**
 * This class is responsible for saving the results to a file at regular
 * intervals. The files saved are "classesStats", "systemStats", "jobs",
 * and "mue"
 * @author Majd Kokaly
 *
 */
public class SavingRunnable implements Runnable {
	
	private boolean alive = true;
	private Mapper mapper;
	private GeneratorsController controller;
	private int timeBetweenSaves;
	
	private Thread thisThread;
	
	
	
	public synchronized boolean isAlive() {
		return alive;
	}
	public synchronized void setAlive(boolean alive) {
		this.alive = alive;
	}
		
	
	public Mapper getMapper() {
		return mapper;
	}
	public void setMapper(Mapper mapper) {
		this.mapper = mapper;
	}
	public GeneratorsController getContoller() {
		return controller;
	}
	public void setContoller(GeneratorsController contoller) {
		this.controller = contoller;
	}
	public int getTimeBetweenSaves() {
		return timeBetweenSaves;
	}
	public void setTimeBetweenSaves(int timeBetweenSaves) {
		this.timeBetweenSaves = timeBetweenSaves;
	}
	public SavingRunnable(Mapper mapper, GeneratorsController controller, int timeBetweenSaves) {
		this.setMapper(mapper);
		this.setContoller(controller);
		this.setTimeBetweenSaves(timeBetweenSaves);

	}

	public static final String RESULTS_FOLDER = "Results";
	DecimalFormat formatter = new DecimalFormat();
	public void run() {
		formatter.setMaximumFractionDigits(1);
		long i = 0;
		String filePrefix = new String();
		while (this.isAlive()) {
			try {
				Thread.sleep(1000 * 60 * this.getTimeBetweenSaves());
			} catch (InterruptedException e) {
				e.printStackTrace();
				if (!this.isAlive())
					return;
			}
			i++;
			filePrefix = this.getMapper().getMappingScheme().getDescription() + "_" + formatter.format(this.mapper.getTimeElapsedInTimeUnits() ) +"_";
			Reporter.generateReportAboutSystemStatistics(this.getMapper(), RESULTS_FOLDER + "/" + filePrefix +"systemStats.txt");
			try {
				Reporter.generateReportAboutJobClasses(this.getMapper(), this.getContoller(), RESULTS_FOLDER + "/" + filePrefix+"classesStats.txt");
				Reporter.generateReportOfMue(this.getMapper(),RESULTS_FOLDER + "/" + filePrefix+"mue.txt");
			} catch (IOException e) {
				e.printStackTrace();
			}
			
			this.getMapper().getJobsTable().saveToFile(RESULTS_FOLDER + "/" +filePrefix+"jobs.txt");
			
		}

	}
	
	public void startThread() {
		this.setAlive(true);
		thisThread = new Thread(this);
		thisThread.start();
	}
	
	public void stopThread() {
		this.setAlive(false);
		thisThread.interrupt();
		String filePrefix;
		filePrefix = this.getMapper().getMappingScheme().getDescription() + "_" +  formatter.format(this.mapper.getTimeElapsedInTimeUnits()) +"_Final_";
		Reporter.generateReportAboutSystemStatistics(this.getMapper(), RESULTS_FOLDER + "/" + filePrefix +"systemStats.txt");
		try {
			Reporter.generateReportAboutJobClasses(this.getMapper(), this.getContoller(), RESULTS_FOLDER + "/" + filePrefix+"classesStats.txt");
			Reporter.generateReportOfMue(this.getMapper(),RESULTS_FOLDER + "/" + filePrefix+"mue.txt");
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		this.getMapper().getJobsTable().saveToFile(RESULTS_FOLDER + "/" +filePrefix+"jobs.txt");
	}

}
