package logging;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import mapping.data.Server;
import mapping.data.ServersTable;


/**
 * This class has one method that is able to read servers from a text file in a special format.
 * 
 * @author Majd Kokaly
 *
 */
public class ServersReader {
	
	/**
	 * This method reads Server objects from a file.
	 * Every server should be stored on one line in the following format:
	 * servername
	 * 
	 * @param fileName a file name containing the servers
	 * @param table a ServersTable object to store the obtained servers in 
	 */
	public static void readServersFromFile(String fileName, ServersTable table ) {
		String line;
		BufferedReader bufferedReader = null;
		FileReader fileReader = null;
		
		Server server = null;
		try {
			fileReader = new FileReader(fileName);
			bufferedReader = new BufferedReader(fileReader);
			while ((line = bufferedReader.readLine()) != null) {
				
				server = new Server(line);
				table.addServer(server);
			} 
		} 
		catch (IOException ex) {
			ex.printStackTrace();
		} finally {
			if (fileReader != null)
				try {
					fileReader.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			if (bufferedReader != null)
				try {
					bufferedReader.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
		}

	}
	
	public static void main(String[] args) {
		ServersTable table = new ServersTable();
		readServersFromFile("servers.txt", table);
		table.printAll();
	}
}
