/**
 * 
 */
package mapping.data;

import java.util.Hashtable;

/**
 * @author Majd Kokaly
 * 
 * This class is a representation of the matrix delta star that the LPAS_DG
 * scheduling schemes use. Please refer to the LPAS_DG section in the thesis
 * Document.
 * 
 */
public class DeltaStar extends Hashtable<Tuple, Integer> {

	/**
	 * The serialVersionUID is used to universally identify this version of this
	 * class.
	 */
	private static final long serialVersionUID = 6645909141253454235L;

	/**
	 * This is the lambda star obtained when solving the LP allocation. Please
	 * refer to the LPAS_DG section in the thesis Document.
	 */
	private double lambdaStart;

	public DeltaStar(int initialCapacity) {
		super(initialCapacity);
	}

	public double getLambdaStart() {
		return lambdaStart;
	}

	public void setLambdaStart(double lambdaStart) {
		this.lambdaStart = lambdaStart;
	}
	
	/**
	 * This method adds a Zero to this sparse matrix
	 * @param i  what row in the matrix
	 * @param j what column in the matrix
	 */
	public void addZero(int i, int j) {
		this.put(new Tuple(i, j), new Integer(0));
	}
	
	/**
	 * 
	 * @param i is the row
	 * @param j is the column
	 * @return true the entry (i,j) is zero, and false otherwise
	 */
	public boolean isZero(int i, int j) {
		return this.containsKey(new Tuple(i, j));
	}

	public void printAll() {
		System.out.println("Lambda is:" + this.getLambdaStart());
		System.out.println(this.toString());
	}

	public static void main(String args[]) {
		DeltaStar ds = new DeltaStar(50);
		ds.addZero(3, 3);
		ds.addZero(3, 3);
		ds.addZero(3, 3);
		ds.addZero(3, 3);
		ds.addZero(3, 3);

		System.out.println(ds.containsKey(new Tuple(3, 3)));

		ds.printAll();

	}

}
