package mapping.data;

import java.io.Serializable;
import java.util.Hashtable;

/**
 * This class represents the collection of job classes. It was implemented as a
 * Hashtable. This class is thread safe.
 * 
 * @author Majd Kokaly
 */
public class JobClassesTable extends Hashtable<Integer, JobClass> implements Serializable {

	/**
	 * The serialVersionUID is used to universally identify this version of this
	 * class.
	 */
	private static final long serialVersionUID = 8873582789663642107L;

	/**
	 * This is a counter to assign unique IDs to the jobs
	 */
	private int jobClassID = 1; // Every job class has its own id. This variable

	// is responsible for that. It starts from 1

	/**
	 * Default constructor
	 */
	public JobClassesTable() {
	}

	/**
	 * 
	 * @param initialCapacity
	 *            expected number of job classes
	 */
	public JobClassesTable(int initialCapacity) {
		super(initialCapacity);
	}

	/**
	 * This method is used to add Job Classes objects.
	 * 
	 * @param jobClass
	 *            the object to be added
	 */
	public void addJobClass(JobClass jobClass) {
		jobClass.setIndex(jobClassID++);
		this.put(new Integer(jobClass.getIndex()), jobClass);
	}

	/**
	 * This method is used to add Job Classes objects.
	 * 
	 * @param arrivingRate
	 *            the arrival rate of the object to be created.
	 * @param executionTime
	 *            the executionTime of the object to be created.
	 */
	public void addJobClass(double arrivingRate, long executionTime) {
		JobClass jobClass = new JobClass(arrivingRate);
		jobClass.setIndex(jobClassID++);
		jobClass.setexecutionTime(executionTime);
		this.put(new Integer(jobClass.getIndex()), jobClass);
	}

	public void printAll() {
		System.out.println(this.toString());
	}

	/**
	 * This method removes the job class with id if it exists and reorders the rest
	 * of job classes. The IDs of the job classes are always between 1 - N
	 * without any missing numbers.
	 * 
	 * @param id
	 *            the id of the job classes to be deleted.
	 */
	public void removeJobClass(int id) {
		this.remove(id);

		JobClass jc = null;
		jobClassID = id;
		for (int i = id + 1; i <= this.size() + 1; i++) {
			jc = this.remove(i);
			this.addJobClass(jc);
		}
	}

}
