package mapping.data;

import java.io.Serializable;

/**
 * 
 * @author Majd Kokaly
 * 
 * This class contain two doubles. One of them resembles the assumed processing rate
 * The other one resembles the real one.
 */
public class ProcessingRatesPair implements Serializable{

	/**
	 * The serialVersionUID is used to universally identify this version of this
	 * class.
	 */
	private static final long serialVersionUID = -3835736561464024433L;
	
	/**
	 * The real rate in tasks per time unit.
	 */
	double realRate; 		// Task per time unit.
	
	/**
	 * The assumed rate in tasks per time unit.
	 */
	double assumedRate;  	// Task per time unit.
	
	public ProcessingRatesPair(double realRate, double assumedRate) {
		super();
		this.realRate = realRate;
		this.assumedRate = assumedRate;
	}
	
	public double getRealRate() {
		return realRate;
	}
	public void setRealRate(double realRate) {
		this.realRate = realRate;
	}
	public double getAssumedRate() {
		return assumedRate;
	}
	public void setAssumedRate(double assumedRate) {
		this.assumedRate = assumedRate;
	}
	
	public String toString() {
			return "Real Processing Rate is: " + this.getRealRate() +  "and Assumed processing rate is: " + this.getAssumedRate();
	}
		
}
