package mapping.data;

/**
 * This class is a listener to events happening to the ServerTable
 * 
 * @author Majd Kokaly
 *
 * @see ServersTable
 * 
 */
public interface ServersTableListener {

	/**
	 * This method is invoked when the hostname of a server is changed.
	 * @param serverID The ID of the server in subject.
	 * @param hostname The new hostname.
	 */
	public void hostNameChanged(int serverID, String hostname);
	
	/**
	 * This method is invoked when the password of a server is changed.
	 * @param serverID The ID of the server in subject.
	 * @param password The new password.
	 */
	public void passwordChanged(int serverID, String password);
	
	/**
	 * This method is invoked when the down/up status of a server is changed.
	 * @param serverID The ID of the server in subject.
	 * @param down The new up/down status.
	 */
	public void upDownStatusChanged(int serverID, boolean down);
}
