package probability_distribution;

/**
 * This abstract class defines the method that a probability distribution should provide.
 * 
 * @author Majd Kokaly
 *
 */
public abstract class ProbabilityDist {
	/**
	 * For example, producing a collection of 100 numbers by invoking this method 100 times,
	 * will produce a collection of numbers that conform to a specific
	 * probability distribution.
	 * 
	 * The probability distribution is determined by the implementation of this
	 * abstract class.
	 * 
	 * This method, for instance could be used to give the time between events, if
	 * these events happen to follow a specific distribution.
	 */
	public double getNextValue()
	{
		return FInverse(Math.random());
	}
	/**
	 * Just an alias for getNextValue.
	 * 
	 * @return getNextValue()
	 */
	
	public final double getTimeToNextEvent() 
	{
		return FInverse(Math.random());
	}
	
	/**
	 * Every Probability Distribution should include a function which returns the inverse of
	 * probability function
	 * @return
	 */
	public abstract double FInverse(double x);
	
	/**
	 * Every Probability Distribution should also include a function which when called returns
	 * the inverse of the probability function using a random value
	 * @return
	 */
	public abstract double FInverse();
}
