package pulling.availability_imposer;

import java.io.Serializable;

/**
 * This class resembles the availability Net. This net models the availability
 * on machines. It is constructed from Nodes. Every node represents a state of
 * availability for the server. The move to the next node depends on probability
 * assigned with Arches connecting the nodes
 * 
 * @author Majd Kokaly
 * 
 */
public class Net implements Serializable {

	/**
	 * The serialVersionUID is used to universally identify this version of this
	 * class.
	 */
	private static final long serialVersionUID = -2613849368573511720L;

	/**
	 * The root node or the start node.
	 */
	private Node startNode;

	public Node getStartNode() {
		return startNode;
	}

	public void setStartNode(Node startNode) {
		this.startNode = startNode;
	}

	public void traverse() {
		java.util.Stack<Node> stack = new java.util.Stack<Node>();
		this.getStartNode().print();
		this.getStartNode().visited = true;
		stack.push(this.getStartNode());

		Node n2;
		while (!stack.isEmpty()) {
			Node n1 = stack.pop();
			for (int i = 0; i < n1.getNeighboursNumber(); i++) {
				n2 = n1.getNeighbour(i);
				if (n2.visited == false) {
					n2.visit();
					stack.push(n2);
				}
			}
			System.out.print("-------------\n");
		}
	}

	public static void main(String args[]) {
		Node n1 = new Node(0.5, "N1", 1000);
		Node n2 = new Node(0.5, "N2", 2000);
		Node n3 = new Node(0.5, "N3", 3000);
		Node n4 = new Node(0.5, "N4", 4000);

		n1.addArch(0.3, n3);
		n1.addArch(0.7, n2);

		n2.addArch(0.4, n3);
		n2.addArch(0.6, n1);

		n3.addArch(0.4, n4);
		n3.addArch(0.3, n2);
		n3.addArch(0.3, n1);

		n4.addArch(0.5, n1);
		n4.addArch(0.5, n3);

		// n1.print();

		Net net = new Net();
		net.setStartNode(n1);

		net.traverse(); // print

		Thread t = new Thread(new AvailabilityImposer(net));
		t.start();

	}

}
