package pulling.availability_predection;

import java.util.Calendar;
/**
 * This is a utility class to express the hour of the day, used by the AvailabilityManager Class 
 * @author Majd Kokaly
 *
 */
public enum Hour {
		/**
		* 00:00 - 01:00
		*/
		H00,
		/**
		* 01:00 - 02:00
		*/
		H01,
		/**
		* 02:00 - 03:00
		*/
		H02,
		/**
		* 03:00 - 04:00
		*/
		H03,
		/**
		* 04:00 - 05:00
		*/
		H04,
		/**
		* 05:00 - 06:00
		*/
		H05,
		/**
		* 06:00 - 07:00
		*/
		H06,
		/**
		* 07:00 - 08:00
		*/
		H07,
		/**
		* 08:00 - 09:00
		*/
		H08,
		/**
		* 09:00 - 10:00
		*/
		H09,
		/**
		* 10:00 - 11:00
		*/
		H10,
		/**
		* 11:00 - 12:00
		*/
		H11,
		/**
		* 12:00 - 13:00
		*/
		H12,
		/**
		* 13:00 - 14:00
		*/
		H13,
		/**
		* 14:00 - 15:00
		*/
		H14,
		/**
		* 15:00 - 16:00
		*/
		H15,
		/**
		* 16:00 - 17:00
		*/
		H16,
		/**
		* 17:00 - 18:00
		*/
		H17,
		/**
		* 18:00 - 19:00
		*/
		H18,
		/**
		* 19:00 - 20:00
		*/
		H19,
		/**
		* 20:00 - 21:00
		*/
		H20,
		/**
		* 21:00 - 22:00
		*/
		H21,
		/**
		* 22:00 - 23:00
		*/
		H22,
		/**
		* 23:00 - 24:00
		*/
		H23;
		
		 /** Simple Mapping between java.util.Calendar and WeekDay enumeration
	     * 
	     * @param calendar	an instance of type java.util.Calendar
	     * @return	The Hour of this calendar (date).
	     */
	    public static Hour getHour(Calendar calendar) {
	    	switch (calendar.get( Calendar.HOUR_OF_DAY)) {
	    		case 0: return Hour.H00; 
	    		case 1: return Hour.H01;
	    		case 2: return Hour.H02;
	    		case 3: return Hour.H03;
	    		case 4: return Hour.H04;
	    		case 5: return Hour.H05;
	    		case 6: return Hour.H06;
	    		case 7: return Hour.H07;
	    		case 8: return Hour.H08;
	    		case 9: return Hour.H09;
	    		case 10: return Hour.H10;
	    		case 11: return Hour.H11;
	    		case 12: return Hour.H12;
	    		case 13: return Hour.H13;
	    		case 14: return Hour.H14;
	    		case 15: return Hour.H15;
	    		case 16: return Hour.H16;
	    		case 17: return Hour.H17;
	    		case 18: return Hour.H18;
	    		case 19: return Hour.H19;
	    		case 20: return Hour.H20; 
	    		case 21: return Hour.H21;
	    		case 22: return Hour.H22;
	    		default: return Hour.H23;
	    	}
	    }
}
