package pulling.availability_predection;

import java.util.GregorianCalendar;

/**
 * It represents a time stamp (hour and minute) of an entry in the file created by the AvailabilityLogger (e.g. 12_10)
 * @author Majd Kokaly
 *
 */
public class TimeStamp {
	private int hour;
	private int minute;
	
	public TimeStamp() {
		this.setHour(0);
		this.setMinute(0);
	}
	
	public TimeStamp(int hour, int minute) {
		this.setHour(hour);
		this.setMinute(minute);
	}
	
	public int getHour() {
		return hour;
	}
	public void setHour(int hour) {
		this.hour = hour % 60;
	}
	
	public int getMinute() {
		return minute;
	}
	
	public void setMinute(int minute) {
		this.minute = minute % 60;
	}
	
	public void addHours(int addedHours) {
		this.setHour( (this.getHour() + addedHours)% 24  );
	}
	
	public void addMinutes(int addedMinutes) {
		this.addHours( (this.getMinute()+addedMinutes)/60);
		this.setMinute( (this.getMinute()+addedMinutes ) % 60 );
	}
	
	public String toString() {
		String hour = "" + this.getHour();
		String minute = "" + this.getMinute();
		if ( this.getHour() < 10) {
			hour = "0" + hour;
		}
		if ( this.getMinute() < 10) {
			minute = "0" + minute;
		}
		return hour + "_" + minute;
	}
	
	public int howManyPeriodsBefore(int period) {
		int sum = this.getHour() * 60 / period;
		sum += this.getMinute() / period;
		return sum;
	}
	
	public void print() {
		System.out.println(this.toString());
	}
	
	public static void main(String[] args) {
		TimeStamp t = new TimeStamp( 0,0 );
		for (int i = 0; i < 1000; i++) {
			t.print();
			t.addMinutes(7);
		}
	}
	
	public static TimeStamp getTimeStamp(GregorianCalendar cal) {
		if (cal.get(GregorianCalendar.AM_PM) == GregorianCalendar.AM) {
			return new TimeStamp(cal.get(GregorianCalendar.HOUR) , cal.get(GregorianCalendar.MINUTE));
		} else
			return new TimeStamp(cal.get(GregorianCalendar.HOUR ) + 12 , cal.get(GregorianCalendar.MINUTE));
	}
	
}
