package pulling.availability_predection;

import java.util.Calendar;
/**
 * It is the weekday enumeration used in the file created by the AvailabilityLogger
 * @author Majd Kokaly
 *
 */
public enum WeekDay {
	    /**
	     * Monday
	     */
	    MONDAY,
	    /**
	     * Tuesday
	     */
	    TUESDAY,
	    /**
	     * Wednesday
	     */
	    WEDNESDAY,
	    /**
	     * Thursday
	     */
	    THURSDAY,
	    /**
	     * Friday
	     */
	    FRIDAY,
	    /**
	     * Saturday
	     */
	    SATURDAY,
	    /**
	     * Sunday
	     */
	    SUNDAY;
	    
	    
	    /** Simple Mapping between java.util.Calendar and WeekDay enumaration
	     * 
	     * @param calendar	an instance of type java.util.Calendar
	     * @return	The WeekDay of this calendar (date).
	     */
	    public static WeekDay getWeekDay(Calendar calendar) {
	    	switch (calendar.get( Calendar.DAY_OF_WEEK)) {
	    		case Calendar.MONDAY : return WeekDay.MONDAY; 
	    		case Calendar.TUESDAY : return WeekDay.TUESDAY; 
	    		case Calendar.WEDNESDAY : return WeekDay.WEDNESDAY; 
	    		case Calendar.THURSDAY : return WeekDay.THURSDAY;
	    		case Calendar.FRIDAY : return WeekDay.FRIDAY; 
	    		case Calendar.SATURDAY : return WeekDay.SATURDAY; 
	    		case Calendar.SUNDAY : return WeekDay.SUNDAY; 
	    		default: return WeekDay.MONDAY;
	    	}
	    }
}
