/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.HashMap;
import java.util.Map;
import lindenmayer.parser.DuplicateVariableException;
import lindenmayer.parser.ExpressionBoolean;
import lindenmayer.parser.SymbolConstant;
import lindenmayer.parser.SymbolVariable;
import lindenmayer.parser.System;
import lindenmayer.parser.UndefinedVariableException;
import lindenmayer.parser.WordConstant;
import lindenmayer.parser.WordExpression;
import lindenmayer.parser.WordVariable;

public class Rule {
    WordVariable leftContext;
    WordVariable rightContext;
    SymbolVariable symbol;
    ExpressionBoolean condition;
    WordExpression substitute;
    Map variableIdMap;

    public Rule(System system, WordVariable leftContext, WordVariable rightContext, SymbolVariable symbol, ExpressionBoolean condition, WordExpression substitute) throws UndefinedVariableException, DuplicateVariableException {
        int j;
        int i;
        this.leftContext = leftContext;
        this.rightContext = rightContext;
        this.symbol = symbol;
        this.condition = condition;
        this.substitute = substitute;
        if (symbol == null) {
            throw new IllegalArgumentException();
        }
        if (substitute == null) {
            throw new IllegalArgumentException();
        }
        this.variableIdMap = new HashMap(system.getConstantDefinition().getVariableMap());
        if (leftContext != null) {
            for (i = 0; i < leftContext.symbols.length; ++i) {
                for (j = 0; j < leftContext.symbols[i].parameters.length; ++j) {
                    if (this.variableIdMap.containsKey(leftContext.symbols[i].parameters[j].id)) {
                        throw new DuplicateVariableException(String.valueOf(String.valueOf(new StringBuffer("Duplicate definition of variable ").append(leftContext.symbols[i].parameters[j].id).append("."))));
                    }
                    this.variableIdMap.put(leftContext.symbols[i].parameters[j].id, leftContext.symbols[i].parameters[j]);
                }
            }
        }
        if (rightContext != null) {
            for (i = 0; i < rightContext.symbols.length; ++i) {
                for (j = 0; j < rightContext.symbols[i].parameters.length; ++j) {
                    if (this.variableIdMap.containsKey(rightContext.symbols[i].parameters[j].id)) {
                        throw new DuplicateVariableException(String.valueOf(String.valueOf(new StringBuffer("Duplicate definition of variable ").append(leftContext.symbols[i].parameters[j].id).append("."))));
                    }
                    this.variableIdMap.put(rightContext.symbols[i].parameters[j].id, rightContext.symbols[i].parameters[j]);
                }
            }
        }
        for (i = 0; i < symbol.parameters.length; ++i) {
            if (this.variableIdMap.containsKey(symbol.parameters[i].id)) continue;
            this.variableIdMap.put(symbol.parameters[i].id, symbol.parameters[i]);
        }
        if (condition != null) {
            condition.assignVariables(this.variableIdMap);
        }
        substitute.assignVariables(this.variableIdMap);
    }

    public boolean isApplyable(WordConstant word, int position) {
        int i;
        if (word.symbols[position].symbol != this.symbol.symbol) {
            return false;
        }
        if (this.leftContext != null && position < this.leftContext.symbols.length) {
            return false;
        }
        if (this.rightContext != null && word.symbols.length <= position + this.rightContext.symbols.length) {
            return false;
        }
        if (this.leftContext != null) {
            for (i = 0; i < this.leftContext.symbols.length; ++i) {
                if (word.symbols[position - 1 - i].symbol == this.leftContext.symbols[this.leftContext.symbols.length - 1 - i].symbol) continue;
                return false;
            }
        }
        if (this.rightContext != null) {
            for (i = 0; i < this.rightContext.symbols.length; ++i) {
                if (word.symbols[position + 1 + i].symbol == this.rightContext.symbols[i].symbol) continue;
                return false;
            }
        }
        if (this.condition != null) {
            if (this.leftContext != null) {
                for (i = 0; i < this.leftContext.symbols.length; ++i) {
                    this.leftContext.symbols[this.leftContext.symbols.length - 1 - i].retrieveValues(word.symbols[position - 1 - i]);
                }
            }
            if (this.rightContext != null) {
                for (i = 0; i < this.rightContext.symbols.length; ++i) {
                    this.rightContext.symbols[i].retrieveValues(word.symbols[position + 1 + i]);
                }
            }
            this.symbol.retrieveValues(word.symbols[position]);
            if (!this.condition.evaluateBoolean()) {
                return false;
            }
        }
        return true;
    }

    public WordConstant apply(WordConstant word, int position) {
        int i;
        if (this.leftContext != null) {
            for (i = 0; i < this.leftContext.symbols.length; ++i) {
                this.leftContext.symbols[this.leftContext.symbols.length - 1 - i].retrieveValues(word.symbols[position - 1 - i]);
            }
        }
        if (this.rightContext != null) {
            for (i = 0; i < this.rightContext.symbols.length; ++i) {
                this.rightContext.symbols[i].retrieveValues(word.symbols[position + 1 + i]);
            }
        }
        this.symbol.retrieveValues(word.symbols[position]);
        SymbolConstant[] result = new SymbolConstant[this.substitute.symbols.length];
        for (int i2 = 0; i2 < this.substitute.symbols.length; ++i2) {
            result[i2] = this.substitute.symbols[i2].evaluateSymbol();
        }
        return new WordConstant(result);
    }

    public String toString() {
        String result = "";
        if (this.leftContext != null) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("<").append(this.leftContext.toString()).append("> "))))));
        }
        result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(this.symbol)));
        if (this.rightContext != null) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" <").append(this.rightContext).append(">"))))));
        }
        if (this.condition != null) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" [").append(this.condition).append("] "))))));
        }
        result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(" = ".concat(String.valueOf(String.valueOf(this.substitute))))));
        return result;
    }
}

