/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.Map;
import lindenmayer.parser.ExpressionArithmetic;
import lindenmayer.parser.SymbolConstant;
import lindenmayer.parser.SymbolDefinition;
import lindenmayer.parser.UndefinedVariableException;
import lindenmayer.parser.WrongSignatureException;

public class SymbolExpression {
    SymbolDefinition symbol;
    ExpressionArithmetic[] parameters;

    public SymbolExpression(SymbolDefinition symbol, ExpressionArithmetic[] parameters) throws WrongSignatureException {
        if (parameters == null && symbol.parameterCount > 0 || parameters.length != symbol.parameterCount) {
            throw new WrongSignatureException(String.valueOf(String.valueOf(new StringBuffer("Symbol ").append(symbol.id).append(" requires ").append(symbol.parameterCount).append(" parameters, found: ").append(parameters.length))));
        }
        this.symbol = symbol;
        this.parameters = parameters;
    }

    public void assignVariables(Map variableIdMap) throws UndefinedVariableException {
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i].assignVariables(variableIdMap);
            }
        }
    }

    public SymbolConstant evaluateSymbol() {
        double[] values;
        if (this.parameters != null) {
            values = new double[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                values[i] = this.parameters[i].evaluateDouble();
            }
        } else {
            values = null;
        }
        try {
            SymbolConstant i = new SymbolConstant(this.symbol, values);
            return i;
        }
        catch (WrongSignatureException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public String toString() {
        String result = this.symbol.id;
        if (this.parameters.length > 0) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf("(".concat(String.valueOf(String.valueOf(this.parameters[0].toString()))))));
            for (int i = 1; i < this.parameters.length; ++i) {
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(", ".concat(String.valueOf(String.valueOf(this.parameters[i].toString()))))));
            }
            result = String.valueOf(String.valueOf(result)).concat(")");
        }
        return result;
    }
}

