/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.system;

import lindenmayer.system.Expression;
import lindenmayer.system.Number;

public class Term
extends Expression {
    public static final int OP_ADD = 1;
    public static final int OP_SUB = 2;
    public static final int OP_MUL = 3;
    public static final int OP_DIV = 4;
    public static final int OP_POW = 5;
    public static final int OP_FAC = 6;
    public static final int OP_SQRT = 7;
    public static final int OP_ROOT = 8;
    public static final int OP_SQR = 9;
    Expression[] operands;
    int operator;

    public Term(Expression[] operands, int operator) {
        this.operands = operands;
        this.operator = operator;
    }

    public Term(Expression operand1, int operator, Expression operand2) {
        this.operator = operator;
        this.operands = new Expression[2];
        this.operands[0] = operand1;
        this.operands[1] = operand2;
    }

    public double evaluateDouble() {
        double result;
        switch (this.operator) {
            case 1: {
                result = 0.0;
                for (int i = 0; i < this.operands.length; ++i) {
                    result += this.operands[i].evaluateDouble();
                }
                break;
            }
            case 2: {
                if (this.operands.length < 1) {
                    throw new IllegalStateException();
                }
                result = this.operands[0].evaluateDouble();
                for (int i = 1; i < this.operands.length; ++i) {
                    result -= this.operands[i].evaluateDouble();
                }
                break;
            }
            case 3: {
                result = 1.0;
                for (int i = 0; i < this.operands.length; ++i) {
                    result *= this.operands[i].evaluateDouble();
                }
                break;
            }
            case 4: {
                if (this.operands.length < 1) {
                    throw new IllegalStateException();
                }
                result = this.operands[0].evaluateDouble();
                for (int i = 1; i < this.operands.length; ++i) {
                    result /= this.operands[i].evaluateDouble();
                }
                break;
            }
            case 5: {
                if (this.operands.length < 1) {
                    throw new IllegalStateException();
                }
                result = this.operands[0].evaluateDouble();
                for (int i = 1; i < this.operands.length; ++i) {
                    result = Math.pow(result, this.operands[i].evaluateDouble());
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    public long evaluateLong() {
        return (long)this.evaluateDouble();
    }

    public boolean evaluateBoolean() {
        return this.evaluateLong() != (long)0;
    }

    public static void main(String[] args) {
        double result = new Term(new Term(new Number(2.0), 1, new Number(3.0)), 3, new Number(2.0)).evaluateDouble();
        System.out.println(result);
    }

    static {
        OP_ADD = 1;
        OP_SUB = 2;
        OP_MUL = 3;
        OP_DIV = 4;
        OP_POW = 5;
        OP_FAC = 6;
        OP_SQRT = 7;
        OP_ROOT = 8;
        OP_SQR = 9;
    }
}

