/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.turtle2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JFrame;
import lindenmayer.parser.Method;
import lindenmayer.parser.Provider;
import lindenmayer.parser.Variable;

public class Turtle2D
extends JComponent
implements Provider {
    Method move = new Method(){

        public String getId() {
            return "move";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle2D.this.state.x += Math.sin(Turtle2D.this.state.r) * parameters[0];
            Turtle2D.this.state.y -= Math.cos(Turtle2D.this.state.r) * parameters[0];
            Turtle2D.this.sections.add(Turtle2D.this.state.createSection(false));
            Turtle2D.this.repaint();
            return 0.0;
        }
    };
    Method draw = new Method(){

        public String getId() {
            return "draw";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle2D.this.state.x += Math.sin(Turtle2D.this.state.r) * parameters[0];
            Turtle2D.this.state.y -= Math.cos(Turtle2D.this.state.r) * parameters[0];
            Turtle2D.this.sections.add(Turtle2D.this.state.createSection(true));
            Turtle2D.this.repaint();
            return 0.0;
        }
    };
    Method rotate = new Method(){

        public String getId() {
            return "rotate";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle2D.this.state.r += parameters[0];
            return Turtle2D.this.state.r;
        }
    };
    Method setRotation = new Method(){

        public String getId() {
            return "setRotation";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            Turtle2D.this.state.r = parameters[0];
            return Turtle2D.this.state.r;
        }
    };
    Method getRotation = new Method(){

        public String getId() {
            return "getRotation";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            return Turtle2D.this.state.r;
        }
    };
    Method stroke = new Method(){

        public String getId() {
            return "stroke";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            if (Turtle2D.this.state.stroke + parameters[0] >= 0.0) {
                Turtle2D.this.state.stroke += parameters[0];
            } else {
                throw new IllegalArgumentException("Stroke must be greater than 0.");
            }
            return Turtle2D.this.state.stroke;
        }
    };
    Method setStroke = new Method(){

        public String getId() {
            return "setStroke";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            if (!(parameters[0] >= 0.0)) {
                throw new IllegalArgumentException("Stroke must be greater than 0.");
            }
            Turtle2D.this.state.stroke = parameters[0];
            return Turtle2D.this.state.stroke;
        }
    };
    Method getStroke = new Method(){

        public String getId() {
            return "getStroke";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            return Turtle2D.this.state.stroke;
        }
    };
    Method setColorRed = new Method(){

        public String getId() {
            return "setColorRed";
        }

        public int getParameterCount() {
            return 1;
        }

        public double execute(double[] parameters) {
            float[] c = Turtle2D.this.state.color.getRGBComponents(null);
            c[0] = (float)parameters[0];
            Turtle2D.this.state.color = new Color(c[0], c[1], c[2], c[3]);
            return c[0];
        }
    };
    Method getColorRed = new Method(){

        public String getId() {
            return "getStroke";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            float[] c = Turtle2D.this.state.color.getRGBComponents(null);
            return c[0];
        }
    };
    Method red = new Method(){

        public String getId() {
            return "red";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            Turtle2D.this.state.color = Color.red;
            return 0.0;
        }
    };
    Method green = new Method(){

        public String getId() {
            return "green";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            Turtle2D.this.state.color = Color.green;
            return 0.0;
        }
    };
    Method blue = new Method(){

        public String getId() {
            return "blue";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            Turtle2D.this.state.color = Color.blue;
            return 0.0;
        }
    };
    Method push = new Method(){

        public String getId() {
            return "push";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            Turtle2D.this.stack.push(Turtle2D.this.state);
            Turtle2D.this.state = (State)Turtle2D.this.state.clone();
            return 0.0;
        }
    };
    Method pop = new Method(){

        public String getId() {
            return "pop";
        }

        public int getParameterCount() {
            return 0;
        }

        public double execute(double[] parameters) {
            Turtle2D.this.state = (State)Turtle2D.this.stack.pop();
            Turtle2D.this.sections.add(Turtle2D.this.state.createSection(false));
            return 0.0;
        }
    };
    Method[] methods = new Method[]{this.move, this.draw, this.push, this.pop, this.rotate, this.stroke, this.setRotation, this.getRotation, this.setStroke, this.getStroke, this.setColorRed, this.getColorRed, this.red, this.green, this.blue};
    Variable[] variables = new Variable[0];
    Stack stack = new Stack();
    ArrayList sections = new ArrayList();
    State state;

    public Method[] getMethods() {
        return this.methods;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(Color.black);
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        Iterator i = ((AbstractList)this.sections).iterator();
        double l = 0.0;
        double t = 0.0;
        double r = 0.0;
        double b = 0.0;
        if (i.hasNext()) {
            Section p = (Section)i.next();
            l = p.x;
            r = p.x;
            t = p.y;
            b = p.y;
            while (i.hasNext()) {
                p = (Section)i.next();
                if (p.x < l) {
                    l = p.x;
                }
                if (p.x > r) {
                    r = p.x;
                }
                if (p.y < t) {
                    t = p.y;
                }
                if (!(p.y > b)) continue;
                b = p.y;
            }
        }
        int w = this.getWidth() - 20;
        int h = this.getHeight() - 20;
        double f = 1.0;
        double fx = 1.0;
        double fy = 1.0;
        if (r - l != 0.0 && b - t != 0.0) {
            fx = (double)w / (r - l);
            fy = (double)h / (b - t);
            f = fx < fy ? fx : fy;
        }
        int offX = (int)((double)-1 * l * fx) + 10;
        int offY = (int)((double)-1 * t * fy) + 10;
        i = ((AbstractList)this.sections).iterator();
        if (i.hasNext()) {
            Section p1 = (Section)i.next();
            while (i.hasNext()) {
                Section p2 = (Section)i.next();
                if (p2.draw) {
                    BasicStroke stroke = new BasicStroke((float)p2.stroke);
                    g2.setColor(p2.color);
                    g2.setStroke(stroke);
                    g2.drawLine((int)(p1.x * fx) + offX, (int)(p1.y * fy) + offY, (int)(p2.x * fx) + offX, (int)(p2.y * fy) + offY);
                }
                p1 = p2;
            }
        }
    }

    public Turtle2D() {
        JFrame frame = new JFrame();
        frame.getContentPane().add(this);
        frame.setDefaultCloseOperation(2);
        ((Component)frame).setSize(400, 400);
        ((Component)frame).setVisible(true);
        this.reset();
    }

    public void reset() {
        this.state = new State();
        this.sections.clear();
        this.stack.clear();
        this.sections.add(this.state.createSection(false));
        this.repaint();
    }

    public void init() {
    }

    public void compile() {
    }

    class Section {
        boolean draw;
        double x;
        double y;
        double stroke;
        Color color;

        Section(Turtle2D this$0) {
        }
    }

    class State
    implements Cloneable {
        double r;
        double x;
        double y;
        double stroke;
        Color color;

        public State() {
            this.r = 0.0;
            this.x = 0.0;
            this.y = 0.0;
            this.stroke = 1.0;
            this.color = Color.green;
        }

        public State(double x, double y, double r) {
            this.r = r;
            this.x = x;
            this.y = y;
        }

        public Section createSection(boolean draw) {
            Section s = new Section(Turtle2D.this);
            s.draw = draw;
            s.x = this.x;
            s.y = this.y;
            s.stroke = this.stroke;
            s.color = this.color;
            return s;
        }

        public Object clone() {
            State clone = new State();
            clone.r = this.r;
            clone.x = this.x;
            clone.y = this.y;
            clone.stroke = this.stroke;
            clone.color = this.color;
            return clone;
        }
    }
}

