function blklan (matIn)
%
clc;
global debug separator;
debug = 1;
separator = '===============================';

load(matIn);                    % load the matrix        
n = size(A,1);
bs = size(S,2);
nSteps = n/bs;

if (debug == 1)
    fprintf ('\n======================');
    fprintf (' Block Lanczos Algorithm (MATLAB) ');
    fprintf ('======================\n');
    fprintf ('\nOrder of matrix A = %d, block size = %d\n', n, bs);
    fprintf ('\nMatrix A:\n');
    printMat (A);
    fprintf ('\nStarting Matrix S:\n');
    printMat (S);
end

% block tridiagonal       
t = cputime;
[M,B,Q,nIter,blkTriVec] = BlkLanCom(A,S,nSteps,RandMat);
blkTriTime = cputime - t;

% tridiagonalization
t = cputime;
[a,b,P,triVec] = LanTri(M,B,ones(nIter*bs,1),randVec);
triTime = cputime - t;        
% 
% check errors
[orthErr, err] = errchk (A,nIter*bs,a,b,P,Q);
fprintf ('\nError in orthogonality = %3.2e\t', orthErr);
fprintf ('\nError in factorization = %3.2e\t', err);

%clear A S M B Q a b P;

