/****************************************************************************
 *
 * DataFile.c
 *
 * Abstract 
 *   Implement the functionality to read one file which includes the
 *   data of specific matrices and vectors.
 *
 * Student:  Guohong Liu
 *
 * ID:       0385117
 *
 ****************************************************************************/

#ifdef MATLAB_COMP

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "blklan.h"

/***************************************************************************
 *
 * Abstract
 *   Read a data file into memory which is edited from MATLAB.
 *
 * Input  
 *   fileName   The name of data file.
 *   
 * Output
 *   None
 *
 * Return
 *   DataFile   if data.n = 0, then something is wrong 
 *              when reading data file.
 *
 ***************************************************************************/

DataFile readDataFile (char *fileName)
{
    DataFile data;
    FILE *file;
    char str[100], sign;
    int i, n, bs, len;
    char character;

	if ((file = fopen(fileName, "r+t")) == NULL) {
        printf ("\nreadDataFile: Can't open data file %s.", file);
        data.n = 0;
        return data;
    }

    fscanf (file, "%s", str);
    /* Skip comment.                */
    while (str[0] == '%') {
        while (fgetc (file) != '\n') {};
        fscanf (file, "%s", str);
    }
    n = atoi (str);
    fscanf (file, "%s", str);
    bs = atoi (str);
    data.n = n;
    data.bs = bs;

    /* Allocate memory for data.    */
    if (!(data.A = (DoubleComplex *)
                    malloc (n * n * sizeof (DoubleComplex)))) {
        printf ("readDataFile: Malloc for matrix A is failed.\n");
        data.n = 0;
        return data;
    }
    if (!(data.S = (DoubleComplex *)
                    malloc (n * bs * sizeof (DoubleComplex)))) {
        printf ("readDataFile: Malloc for matrix S is failed.\n");
        free (data.A);
        data.n = 0;
        return data;
    }
    if (!(data.RandMat = (DoubleComplex *)
                          malloc (bs * bs * sizeof (DoubleComplex)))) {
        printf ("readDataFile: Malloc for matrix A is failed.\n");
        free (data.A);
        free (data.S);
        data.n = 0;
        return data;
    }
    if (!(data.randVec = (DoubleComplex *)
                          malloc (n * sizeof (DoubleComplex)))) {
        printf ("readDataFile: Malloc for matrix A is failed.\n");
        free (data.A);
        free (data.S);
        free (data.RandMat);
        data.n = 0;
        return data;
    }

    /* Read matrix A from data file.            */
    i = 0;
    while (i < n * n) {
        /* Read the real part of the complex.   */
        fscanf (file, "%s", str);
        while (str[0] == '%') {
            while ((character = fgetc (file)) != '\n') {};
            fscanf (file, "%s", str);
        }
        data.A[i].r = atof (str);

        /* Read the image part of the complex.  */
        fscanf (file, "%s", &sign);
        fscanf (file, "%s", str);
        /* Delete 'i' in the string.            */
        len = strlen (str);
        str[len - 1] = '\0';
        if (sign == '+') {
            data.A[i].i = atof (str);
        }
        else if (sign == '-') {
            data.A[i].i = 0 - atof (str);
        }

        i++;
    }

    /* Read matrix S from data file.            */
    i = 0;
    while (i < n * bs) {
        /* Read the real part of the complex.   */
        fscanf (file, "%s", str);
        while (str[0] == '%') {
            while (fgetc (file) != '\n') {};
            fscanf (file, "%s", str);
        }
        data.S[i].r = atof (str);
        data.S[i].i = 0.0;

        i++;
    }

    /* Read random matrix from data file.       */
    i = 0;
    while (i < bs * bs) {
        /* Read the real part of the complex.   */
        fscanf (file, "%s", str);
        while (str[0] == '%') {
            while (fgetc (file) != '\n') {};
            fscanf (file, "%s", str);
        }
        data.RandMat[i].r = atof (str);

        /* Read the image part of the complex.  */
        fscanf (file, "%s", &sign);
        fscanf (file, "%s", str);
        len = strlen (str);
        str[len - 1] = '\0';
        if (sign == '+') {
            data.RandMat[i].i = atof (str);
        }
        else if (sign == '-') {
            data.RandMat[i].i = 0 - atof (str);
        }

        i++;
    }

    /* Read random vector from data file.       */
    i = 0;
    while (i < n) {
        /* Read the real part of the complex.   */
        fscanf (file, "%s", str);
        while (str[0] == '%') {
            while (fgetc (file) != '\n') {};
            fscanf (file, "%s", str);
        }
        data.randVec[i].r = atof (str);

        /* Read the image part of the complex.  */
        fscanf (file, "%s", &sign);
        fscanf (file, "%s", str);
        len = strlen (str);
        str[len - 1] = '\0';
        if (sign == '+') {
            data.randVec[i].i = atof (str);
        }
        else if (sign == '-') {
            data.randVec[i].i = 0 - atof (str);
        }

        i++;
    }

    fclose (file);
    return data;
}

#endif
