/****************************************************************************
 *
 * computing.h
 *
 * Abstract
 *   Define the data structures, the prototypes of routines in
 *   LAPACK and BLAS wrapper, and the prototypes of other low 
 *   level computing routines.
 *
 * Student:  Guohong Liu
 *
 * ID:       0385117
 *
 ****************************************************************************/

#ifndef __LAPACKWRAP_H
#define __LAPACKWRAP_H

#include "f2c.h"
#include "clapack.h"

#define DoubleComplex   doublecomplex
#define DoubleReal      doublereal

/* Data structure for the complex matrix.    */       
typedef struct doubleComplexMat {
    DoubleComplex *mat;
    int m;
    int n;
} DoubleComplexMat;

/* Data structure for the complex vector.    */       
typedef struct doubleComplexVec {
    DoubleComplex *vec;
    int n;
} DoubleComplexVec;

/* Data structure for the real matrix.       */       
typedef struct doubleRealVec {
    DoubleReal *vec;
    int n;
} DoubleRealVec;

/****************************************************************************
 *
 * Prototypes
 *
 ****************************************************************************/

int wrapperInit (int n, int bs);
void freeWrapper ();

int qr (DoubleComplexMat *A, DoubleComplexMat *Q, DoubleComplexMat *R);
void orthogonalize (DoubleComplexMat *A, DoubleComplexMat *B);
int mmult (char *signa, DoubleComplexMat *A, char *transa, 
           DoubleComplexMat *B, char *transb, DoubleComplexMat *C, 
           DoubleComplexMat *R);
int bmmult (char *signa, DoubleComplexMat *A, char *transa, 
            DoubleComplexMat *B, char *transb, 
            DoubleComplexMat *C, DoubleComplexMat *R);
int mdiv (DoubleComplexMat *A, DoubleComplexMat *B, DoubleComplexMat *R);
int mplus (DoubleComplexMat *A, DoubleComplexMat *B, DoubleComplexMat *R);
int memult (doublereal alpha, DoubleComplexMat *A, DoubleComplexMat *B, 
            DoubleComplexMat *C, DoubleComplexMat *R);
void conjmat (DoubleComplexMat *A, DoubleComplexMat *R);
void mscal (double alpha, DoubleComplexMat *A, DoubleComplexMat *R);
double matnorm (DoubleComplexMat *A);
int mvmult (DoubleComplexMat *A, char *transa, DoubleComplexVec *x, 
            DoubleComplexVec *y, DoubleComplexVec *r);
int symvmult (DoubleComplexMat *A, DoubleComplexVec *x, 
              DoubleComplexVec *y, DoubleComplexVec *r);

int vmult (DoubleComplexVec *x, char *transx, DoubleComplexVec *y, 
           DoubleComplex *r);
int vztplus (char *signx, DoubleComplex *alpha, DoubleComplexVec *x, 
             DoubleComplexVec *y, DoubleComplexVec *r);
int vdtplus (char *signx, DoubleReal alpha, DoubleComplexVec *x, 
             DoubleComplexVec *y, DoubleComplexVec *r);
int vplus (DoubleRealVec *x, DoubleRealVec *y, DoubleRealVec *r);
int vzemult (DoubleComplexVec *x, DoubleComplexVec *y, char *transy, 
             DoubleComplexVec *z, DoubleComplexVec *r);
int vdemult (DoubleReal alpha, DoubleRealVec *x, DoubleComplexVec *y, 
             char *transy, DoubleComplexVec *z, DoubleComplexVec *r);
void vscal (double alpha, DoubleComplexVec *x, DoubleComplexVec *r);
double vecnorm (DoubleComplexVec *x);
void conjvec (DoubleComplexVec *x, DoubleComplexVec *r);
int zzmult (char *signa, DoubleComplex *a, DoubleComplex *b, char *transb, 
            DoubleComplex *c, DoubleComplex *r);
int dzmult (char *signa, DoubleReal a, DoubleComplex *b, char *transb, 
            DoubleComplex *c, DoubleComplex *r);
void zdiv (DoubleComplex *a, DoubleReal b, DoubleComplex *r);
DoubleComplex conjg (DoubleComplex z);

void randComplexMat (DoubleComplexMat *A);
void randComplexSymMat (int n, DoubleComplex *A_m);
void randComplexVec (DoubleComplexVec *x);
int randOrthMat (int m, int n, DoubleComplex *A_m);
DoubleComplex randComplexNum ();
void initRandSeed ();
double getEps ();

/****************************************************************************
 *
 * Prototypes of LAPACK 3.0 auxiliary routines which are used in
 * the block Lanczos project.
 * LAPACK doesn't provide a *.h file to contain the prototypes of 
 * these auxiliary routines.
 *
 ****************************************************************************/

doublereal zlange_(char *norm, integer *m, integer *n, doublecomplex *a, 
	               integer *lda, doublereal *work);
doublereal dlange_(char *norm, integer *m, integer *n, doublereal *a, 
                   integer *lda, doublereal *work);
int zlaset_(char *uplo, integer *m, integer *n, doublecomplex *alpha, 
            doublecomplex *beta, doublecomplex *a, integer *lda);
doublereal dlamch_(char *);

#endif /* __LAPACKWRAP_H	*/