function [orthErr, err] = errchk(A,n,a,b,P,varargin)
% [orthErr, err] = errchk(A,n,a,b,P,varargin)
% 
% check the error of orthogonality and factorization
%
% Input
%   A           complex-symmetric matrix.
%   n           matrix size
%   a           main diagonal of the tridiagonal
%   b           subdiagonal of the tridiagonal
%   P           unitary
%   varargin    unitary Q for block Lanczos scheme 
% Output
%   orthErr     error of orthogonality
%   err         error of factorization
%
if nargin == 6
    % The input parameter is for block Lanczos scheme
    Q = varargin{1};
    orthErr = norm((Q*P)'*(Q*P) - eye(n), 'fro');
    orthErr = orthErr/(n*n);
%    
    T = diag(a) + diag(b,1) + diag(b,-1); 
    err = norm((Q*P)'*A*conj(Q*P) - T, 'fro');
    err = err/(n*n);
elseif nargin == 5
    % The input parameter is for scalar lanczos scheme
    orthErr = norm(P'*P - eye(n), 'fro');
    orthErr = orthErr/(n*n);
% 
    T = diag(a) + diag(b,1) + diag(b,-1);       
    err = norm(P'*A*conj(P) - T, 'fro');
    err = err/(n*n);
end
