/* this is a program that demonstrated the use of ioctl */
/* Author: Rong Zheng, last modified: 03/06/06 		*/
#include <stdio.h>
#include <string.h>
#include <unistd.h> 
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <net/route.h>
#include <net/if.h>
#include <net/if_arp.h>

#define usage() \
fprintf(stderr,"%s add [-net|-host] target netmask Nm gw Gw [[dev] If]\n%s del [-net|-host] target netmask Nm gw Gw [[dev] If]\n", \
argv[0],argv[0]);


int main(int argc, char **argv)
{
	struct rtentry rt;
	struct sockaddr_in *isa;
	int fds, i;


	if (argc < 8) {
		usage();
		return -1;
	}

	fds = socket(AF_INET, SOCK_DGRAM, 0);
	memset((char *) &rt, 0, sizeof(rt)); //clear out the route structure
	isa = (struct sockaddr_in *) &rt.rt_dst;

	/* parsing the input */

	for (i = 2; i < argc-1; i= i+2) {
		if (strcmp(argv[i], "-net") == 0) { // this is for a network
			rt.rt_flags = RTF_UP |RTF_GATEWAY;
			isa->sin_family = AF_INET;
			isa->sin_port = 0;
			isa->sin_addr.s_addr = inet_addr(argv[i+1]) ;
		} 

		if (strcmp(argv[i], "-host") == 0) {
			rt.rt_flags = RTF_UP |RTF_HOST;
			isa->sin_family = AF_INET;
			isa->sin_port = 0;
			isa->sin_addr.s_addr = inet_addr(argv[i+1]) ;
		}

		if (strcmp(argv[i], "netmask") == 0) {
			((struct sockaddr_in*)&rt.rt_genmask)->sin_family = AF_INET;
			((struct sockaddr_in*)&rt.rt_genmask)->sin_addr.s_addr = inet_addr(argv[i+1]);
			
		}

		if (strcmp(argv[i], "gw") == 0) {
			((struct sockaddr_in*)&rt.rt_gateway)->sin_family = AF_INET;
			((struct sockaddr_in*)&rt.rt_gateway)->sin_addr.s_addr = inet_addr(argv[i+1]);
			
		}

	}

	
	printf("dst network%s\n", inet_ntoa(((struct sockaddr_in*)&rt.rt_dst)->sin_addr.s_addr));
	printf("mask %s\n", inet_ntoa(((struct sockaddr_in*)&rt.rt_genmask)->sin_addr.s_addr));
	printf("gw %s\n", inet_ntoa(((struct sockaddr_in*)&rt.rt_gateway)->sin_addr.s_addr));

	if (strcmp(argv[1], "add") == 0) {
		if (ioctl(fds, SIOCADDRT, &rt) < 0)
		{
			perror("IP SIOCADDRT");
			close(fds);
			return 1;
		}
	} else if (strcmp(argv[1], "del") == 0) {
		if (ioctl(fds, SIOCDELRT, &rt) < 0)
		{
			perror("IP SIOCDELRT");
			close(fds);
			return 1;
		}
	}
	else {
		usage();
		return -1;
	}	

	close(fds);
	return 0;
}
