#include    <stdio.h>
#include	<stdlib.h>	
#include <netdb.h>
#include    <netinet/in_systm.h>
#include    <netinet/ip.h>
#include    <netinet/ip_icmp.h>
#include    <sys/time.h>
#include    <signal.h>
#include <unistd.h>
#include <errno.h>
#define BUFSIZE     1500

int               verbose;
int 	sockfd;
pid_t    pid;               /* our PID */
char     sendbuf[BUFSIZE];
int      nsent;             /* add 1 for each sendto() */


struct proto {
	void   (*fproc)(char *, ssize_t, struct timeval *);
	void   (*fsend)(void);
	void   (*finit)(void);
	struct sockaddr  *sasend; /* sockaddr{} for send, from getaddrinfo */
	struct sockaddr  *sarecv; /* sockaddr{} for receiving */
	socklen_t     salen;      /* length of sockaddr{}s */
	int           icmpproto;  /* IPPROTO_xxx value for ICMP */
} *pr;

void send_v4(void);
//void proc_v4(char *ptr, ssize_t len, struct msghdr *msg, struct timeval *tvrecv);
void proc_v4(char *ptr, ssize_t len, struct timeval *tvrecv);
void readloop(); 
void sig_alrm(int signo);

void
tv_sub(struct timeval *out, struct timeval *in)
{
	if ( (out->tv_usec -= in->tv_usec) < 0) {   /* out -= in */
		--out->tv_sec;
		out->tv_usec += 1000000;
	}
	out->tv_sec -= in->tv_sec;
}

uint16_t
in_cksum(uint16_t *addr, int len)
{
	int             nleft = len;
	uint32_t        sum = 0;
	uint16_t        *w = addr;
	uint16_t        answer = 0;

	/*
	 * Our algorithm is simple, using a 32 bit accumulator (sum), we add
	 * sequential 16 bit words to it, and at the end, fold back all the
	 * carry bits from the top 16 bits into the lower 16 bits.
	 */
	while (nleft > 1)  {
		sum += *w++;
		nleft -= 2;
	}

	/* 4mop up an odd byte, if necessary */
	if (nleft == 1) {
		*(unsigned char *)(&answer) = *(unsigned char *)w ;
		sum += answer;
	}

	/* 4add back carry outs from top 16 bits to low 16 bits */
	sum = (sum >> 16) + (sum & 0xffff); /* add hi 16 to low 16 */
	sum += (sum >> 16);         /* add carry */
	answer = ~sum;              /* truncate to 16 bits */
	return(answer);
}


