/* this is a program that demonstrated the use of ioctl */
/* Author: Rong Zheng, last modified: 03/06/06 		*/
#include "route.h"

#define usage() \
fprintf(stderr,"%s add [-net|-host] target netmask Nm gw Gw [[dev] If]\n%s del [-net|-host] target netmask Nm gw Gw [[dev] If]\n", \
argv[0],argv[0]);


int main(int argc, char **argv)
{
	int fds, i;
	__u32 dst, gw, mask, ifc;

	if (argc < 8 && argc > 1) {
		usage();
		return -1;
	}

	fds = socket(AF_NETLINK, SOCK_RAW, NETLINK_ROUTE);

	if (argc == 1) {
		show_route(fds);
		exit(0);
	}
	/* parsing the input */

	for (i = 2; i < argc-1; i= i+2) {
		if (strcmp(argv[i], "-net") == 0) { // this is for a network
			dst = inet_addr(argv[i+1]) ;
		} 

		if (strcmp(argv[i], "-host") == 0) {
			dst = inet_addr(argv[i+1]) ;
		}

		if (strcmp(argv[i], "netmask") == 0) {
			mask = inet_addr(argv[i+1]);
			
		}

		if (strcmp(argv[i], "gw") == 0) {
			gw = inet_addr(argv[i+1]);
		}

		if (strcmp(argv[i], "dev") == 0) {
			ifc = atoi(argv[i+1]);
		}

	}

	
	printf("dst network%s\n", inet_ntoa(dst));
	printf("mask %s\n", inet_ntoa(mask));
	printf("gw %s\n", inet_ntoa(gw));

	if (strcmp(argv[1], "add") == 0) {
		route_add(fds, dst, gw, mask, ifc);
		show_route(fds);
	} else if (strcmp(argv[1], "del") == 0) {
		route_del(fds, dst, gw, mask, ifc);
		show_route(fds);
	} 
	else {
		usage();
		return -1;
	}	

	close(fds);
	return 0;
}
